/*
 * Decompiled with CFR 0.152.
 */
package com.android.systemui.shared.system;

import android.app.ActivityOptions;
import android.content.Context;
import android.os.Handler;
import android.view.RemoteAnimationAdapter;
import com.android.systemui.shared.system.RemoteAnimationAdapterCompat;

public abstract class ActivityOptionsCompat {
    public static ActivityOptions makeSplitScreenOptions(boolean dockTopLeft) {
        ActivityOptions options = ActivityOptions.makeBasic();
        options.setLaunchWindowingMode(3);
        options.setSplitScreenCreateMode(dockTopLeft ? 0 : 1);
        return options;
    }

    public static ActivityOptions makeFreeformOptions() {
        ActivityOptions options = ActivityOptions.makeBasic();
        options.setLaunchWindowingMode(5);
        return options;
    }

    public static ActivityOptions makeRemoteAnimation(RemoteAnimationAdapterCompat remoteAnimationAdapter) {
        return ActivityOptions.makeRemoteAnimation((RemoteAnimationAdapter)remoteAnimationAdapter.getWrapped());
    }

    public static ActivityOptions makeCustomAnimation(Context context, int enterResId, int exitResId, final Runnable callback, final Handler callbackHandler) {
        return ActivityOptions.makeCustomAnimation((Context)context, (int)enterResId, (int)exitResId, (Handler)callbackHandler, (ActivityOptions.OnAnimationStartedListener)new ActivityOptions.OnAnimationStartedListener(){

            public void onAnimationStarted() {
                if (callback != null) {
                    callbackHandler.post(callback);
                }
            }
        });
    }
}

