/*
 * Copyright (C) 2019 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.android.launcher3.shadows;

import android.os.Parcel;
import android.os.UserHandle;
import android.os.UserManager;
import android.util.SparseBooleanArray;

import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.shadows.ShadowUserManager;

/**
 * Extension of {@link ShadowUserManager} with missing shadow methods
 */
@Implements(value = UserManager.class)
public class LShadowUserManager extends ShadowUserManager {

    private final SparseBooleanArray mQuietUsers = new SparseBooleanArray();
    private final SparseBooleanArray mLockedUsers = new SparseBooleanArray();

    @Implementation
    protected boolean isQuietModeEnabled(UserHandle userHandle) {
        return mQuietUsers.get(userHandle.hashCode());
    }

    public void setQuietModeEnabled(UserHandle userHandle, boolean enabled) {
        mQuietUsers.put(userHandle.hashCode(), enabled);
    }

    @Implementation
    protected boolean isUserUnlocked(UserHandle userHandle) {
        return !mLockedUsers.get(userHandle.hashCode());
    }

    public void setUserLocked(UserHandle userHandle, boolean enabled) {
        mLockedUsers.put(userHandle.hashCode(), enabled);
    }

    // Create user handle from parcel since UserHandle.of() was only added in later APIs.
    public static UserHandle newUserHandle(int uid) {
        Parcel userParcel = Parcel.obtain();
        userParcel.writeInt(uid);
        userParcel.setDataPosition(0);
        return new UserHandle(userParcel);
    }
}
