/*
 * Decompiled with CFR 0.152.
 */
package com.android.systemui.shared.plugins;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.UserHandle;
import android.util.ArraySet;
import android.util.Log;
import android.view.LayoutInflater;
import com.android.internal.annotations.VisibleForTesting;
import com.android.systemui.plugins.Plugin;
import com.android.systemui.plugins.PluginFragment;
import com.android.systemui.plugins.PluginListener;
import com.android.systemui.shared.plugins.PluginManagerImpl;
import com.android.systemui.shared.plugins.PluginPrefs;
import com.android.systemui.shared.plugins.VersionInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PluginInstanceManager<T extends Plugin> {
    private static final boolean DEBUG = false;
    private static final String TAG = "PluginInstanceManager";
    public static final String PLUGIN_PERMISSION = "com.android.systemui.permission.PLUGIN";
    private final Context mContext;
    private final PluginListener<T> mListener;
    private final String mAction;
    private final boolean mAllowMultiple;
    private final VersionInfo mVersion;
    @VisibleForTesting
    final MainHandler mMainHandler;
    @VisibleForTesting
    final PluginHandler mPluginHandler;
    private final boolean isDebuggable;
    private final PackageManager mPm;
    private final PluginManagerImpl mManager;
    private final ArraySet<String> mWhitelistedPlugins = new ArraySet();

    PluginInstanceManager(Context context, String action, PluginListener<T> listener, boolean allowMultiple, Looper looper, VersionInfo version, PluginManagerImpl manager) {
        this(context, context.getPackageManager(), action, listener, allowMultiple, looper, version, manager, Build.IS_DEBUGGABLE, manager.getWhitelistedPlugins());
    }

    @VisibleForTesting
    PluginInstanceManager(Context context, PackageManager pm, String action, PluginListener<T> listener, boolean allowMultiple, Looper looper, VersionInfo version, PluginManagerImpl manager, boolean debuggable, String[] pluginWhitelist) {
        this.mMainHandler = new MainHandler(Looper.getMainLooper());
        this.mPluginHandler = new PluginHandler(looper);
        this.mManager = manager;
        this.mContext = context;
        this.mPm = pm;
        this.mAction = action;
        this.mListener = listener;
        this.mAllowMultiple = allowMultiple;
        this.mVersion = version;
        this.mWhitelistedPlugins.addAll(Arrays.asList(pluginWhitelist));
        this.isDebuggable = debuggable;
    }

    public PluginInfo<T> getPlugin() {
        if (Looper.myLooper() != Looper.getMainLooper()) {
            throw new RuntimeException("Must be called from UI thread");
        }
        this.mPluginHandler.handleQueryPlugins(null);
        if (this.mPluginHandler.mPlugins.size() > 0) {
            this.mMainHandler.removeMessages(1);
            PluginInfo info = (PluginInfo)this.mPluginHandler.mPlugins.get(0);
            PluginPrefs.setHasPlugins(this.mContext);
            ((Plugin)info.mPlugin).onCreate(this.mContext, info.mPluginContext);
            return info;
        }
        return null;
    }

    public void loadAll() {
        this.mPluginHandler.sendEmptyMessage(1);
    }

    public void destroy() {
        ArrayList plugins = new ArrayList(this.mPluginHandler.mPlugins);
        for (PluginInfo plugin : plugins) {
            this.mMainHandler.obtainMessage(2, plugin.mPlugin).sendToTarget();
        }
    }

    public void onPackageRemoved(String pkg) {
        this.mPluginHandler.obtainMessage(3, pkg).sendToTarget();
    }

    public void onPackageChange(String pkg) {
        this.mPluginHandler.obtainMessage(3, pkg).sendToTarget();
        this.mPluginHandler.obtainMessage(2, pkg).sendToTarget();
    }

    public boolean checkAndDisable(String className) {
        boolean disableAny = false;
        ArrayList plugins = new ArrayList(this.mPluginHandler.mPlugins);
        for (PluginInfo info : plugins) {
            if (!className.startsWith(info.mPackage)) continue;
            this.disable(info);
            disableAny = true;
        }
        return disableAny;
    }

    public boolean disableAll() {
        ArrayList plugins = new ArrayList(this.mPluginHandler.mPlugins);
        for (int i = 0; i < plugins.size(); ++i) {
            this.disable((PluginInfo)plugins.get(i));
        }
        return plugins.size() != 0;
    }

    private void disable(PluginInfo info) {
        Log.w((String)TAG, (String)("Disabling plugin " + info.mPackage + "/" + info.mClass));
        this.mManager.getPluginEnabler().setEnabled(new ComponentName(info.mPackage, info.mClass), false);
    }

    public <T> boolean dependsOn(Plugin p, Class<T> cls) {
        ArrayList plugins = new ArrayList(this.mPluginHandler.mPlugins);
        for (PluginInfo info : plugins) {
            if (!info.mPlugin.getClass().getName().equals(p.getClass().getName())) continue;
            return info.mVersion != null && info.mVersion.hasClass(cls);
        }
        return false;
    }

    public String toString() {
        return String.format("%s@%s (action=%s)", this.getClass().getSimpleName(), this.hashCode(), this.mAction);
    }

    static class PluginInfo<T> {
        private final Context mPluginContext;
        private final VersionInfo mVersion;
        private String mClass;
        T mPlugin;
        String mPackage;

        public PluginInfo(String pkg, String cls, T plugin, Context pluginContext, VersionInfo info) {
            this.mPlugin = plugin;
            this.mClass = cls;
            this.mPackage = pkg;
            this.mPluginContext = pluginContext;
            this.mVersion = info;
        }
    }

    public static class PluginContextWrapper
    extends ContextWrapper {
        private final ClassLoader mClassLoader;
        private LayoutInflater mInflater;

        public PluginContextWrapper(Context base, ClassLoader classLoader) {
            super(base);
            this.mClassLoader = classLoader;
        }

        public ClassLoader getClassLoader() {
            return this.mClassLoader;
        }

        public Object getSystemService(String name) {
            if ("layout_inflater".equals(name)) {
                if (this.mInflater == null) {
                    this.mInflater = LayoutInflater.from((Context)this.getBaseContext()).cloneInContext((Context)this);
                }
                return this.mInflater;
            }
            return this.getBaseContext().getSystemService(name);
        }
    }

    private class PluginHandler
    extends Handler {
        private static final int QUERY_ALL = 1;
        private static final int QUERY_PKG = 2;
        private static final int REMOVE_PKG = 3;
        private final ArrayList<PluginInfo<T>> mPlugins;

        public PluginHandler(Looper looper) {
            super(looper);
            this.mPlugins = new ArrayList();
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    for (int i = this.mPlugins.size() - 1; i >= 0; --i) {
                        PluginInfo plugin = this.mPlugins.get(i);
                        PluginInstanceManager.this.mListener.onPluginDisconnected((Plugin)plugin.mPlugin);
                        if (plugin.mPlugin instanceof PluginFragment) continue;
                        ((Plugin)plugin.mPlugin).onDestroy();
                    }
                    this.mPlugins.clear();
                    this.handleQueryPlugins(null);
                    break;
                }
                case 3: {
                    String pkg = (String)msg.obj;
                    for (int i = this.mPlugins.size() - 1; i >= 0; --i) {
                        PluginInfo plugin = this.mPlugins.get(i);
                        if (!plugin.mPackage.equals(pkg)) continue;
                        PluginInstanceManager.this.mMainHandler.obtainMessage(2, plugin.mPlugin).sendToTarget();
                        this.mPlugins.remove(i);
                    }
                    break;
                }
                case 2: {
                    String p = (String)msg.obj;
                    if (!PluginInstanceManager.this.mAllowMultiple && this.mPlugins.size() != 0) break;
                    this.handleQueryPlugins(p);
                    break;
                }
                default: {
                    super.handleMessage(msg);
                }
            }
        }

        private void handleQueryPlugins(String pkgName) {
            List result;
            Intent intent = new Intent(PluginInstanceManager.this.mAction);
            if (pkgName != null) {
                intent.setPackage(pkgName);
            }
            if ((result = PluginInstanceManager.this.mPm.queryIntentServices(intent, 0)).size() > 1 && !PluginInstanceManager.this.mAllowMultiple) {
                Log.w((String)PluginInstanceManager.TAG, (String)("Multiple plugins found for " + PluginInstanceManager.this.mAction));
                return;
            }
            for (ResolveInfo info : result) {
                ComponentName name = new ComponentName(info.serviceInfo.packageName, info.serviceInfo.name);
                PluginInfo t = this.handleLoadPlugin(name);
                if (t == null) continue;
                PluginInstanceManager.this.mMainHandler.obtainMessage(1, t).sendToTarget();
                this.mPlugins.add(t);
            }
        }

        protected PluginInfo<T> handleLoadPlugin(ComponentName component) {
            if (!PluginInstanceManager.this.isDebuggable && !PluginInstanceManager.this.mWhitelistedPlugins.contains((Object)component.getPackageName())) {
                Log.w((String)PluginInstanceManager.TAG, (String)("Plugin cannot be loaded on production build: " + component));
                return null;
            }
            if (!PluginInstanceManager.this.mManager.getPluginEnabler().isEnabled(component)) {
                return null;
            }
            String pkg = component.getPackageName();
            String cls = component.getClassName();
            try {
                ApplicationInfo info = PluginInstanceManager.this.mPm.getApplicationInfo(pkg, 0);
                if (PluginInstanceManager.this.mPm.checkPermission(PluginInstanceManager.PLUGIN_PERMISSION, pkg) != 0) {
                    Log.d((String)PluginInstanceManager.TAG, (String)("Plugin doesn't have permission: " + pkg));
                    return null;
                }
                ClassLoader classLoader = PluginInstanceManager.this.mManager.getClassLoader(info.sourceDir, info.packageName);
                PluginContextWrapper pluginContext = new PluginContextWrapper(PluginInstanceManager.this.mContext.createApplicationContext(info, 0), classLoader);
                Class<?> pluginClass = Class.forName(cls, true, classLoader);
                Plugin plugin = (Plugin)pluginClass.newInstance();
                try {
                    VersionInfo version = this.checkVersion(pluginClass, plugin, PluginInstanceManager.this.mVersion);
                    return new PluginInfo<Plugin>(pkg, cls, plugin, (Context)pluginContext, version);
                }
                catch (VersionInfo.InvalidVersionException e) {
                    int icon = PluginInstanceManager.this.mContext.getResources().getIdentifier("tuner", "drawable", PluginInstanceManager.this.mContext.getPackageName());
                    int color2 = Resources.getSystem().getIdentifier("system_notification_accent_color", "color", "android");
                    Notification.Builder nb = new Notification.Builder(PluginInstanceManager.this.mContext, "ALR").setStyle((Notification.Style)new Notification.BigTextStyle()).setSmallIcon(icon).setWhen(0L).setShowWhen(false).setVisibility(1).setColor(PluginInstanceManager.this.mContext.getColor(color2));
                    String label = cls;
                    try {
                        label = PluginInstanceManager.this.mPm.getServiceInfo(component, 0).loadLabel(PluginInstanceManager.this.mPm).toString();
                    }
                    catch (PackageManager.NameNotFoundException nameNotFoundException) {
                        // empty catch block
                    }
                    if (!e.isTooNew()) {
                        nb.setContentTitle((CharSequence)("Plugin \"" + label + "\" is too old")).setContentText((CharSequence)("Contact plugin developer to get an updated version.\n" + e.getMessage()));
                    } else {
                        nb.setContentTitle((CharSequence)("Plugin \"" + label + "\" is too new")).setContentText((CharSequence)("Check to see if an OTA is available.\n" + e.getMessage()));
                    }
                    Intent i = new Intent("com.android.systemui.action.DISABLE_PLUGIN").setData(Uri.parse((String)("package://" + component.flattenToString())));
                    PendingIntent pi = PendingIntent.getBroadcast((Context)PluginInstanceManager.this.mContext, (int)0, (Intent)i, (int)0);
                    nb.addAction(new Notification.Action.Builder(null, (CharSequence)"Disable plugin", pi).build());
                    ((NotificationManager)PluginInstanceManager.this.mContext.getSystemService(NotificationManager.class)).notifyAsUser(cls, 6, nb.build(), UserHandle.ALL);
                    Log.w((String)PluginInstanceManager.TAG, (String)("Plugin has invalid interface version " + plugin.getVersion() + ", expected " + PluginInstanceManager.this.mVersion));
                    return null;
                }
            }
            catch (Throwable e) {
                Log.w((String)PluginInstanceManager.TAG, (String)("Couldn't load plugin: " + pkg), (Throwable)e);
                return null;
            }
        }

        private VersionInfo checkVersion(Class<?> pluginClass, T plugin, VersionInfo version) throws VersionInfo.InvalidVersionException {
            VersionInfo pv = new VersionInfo().addClass(pluginClass);
            if (!pv.hasVersionInfo()) {
                int fallbackVersion = plugin.getVersion();
                if (fallbackVersion != version.getDefaultVersion()) {
                    throw new VersionInfo.InvalidVersionException("Invalid legacy version", false);
                }
                return null;
            }
            version.checkVersion(pv);
            return pv;
        }
    }

    private class MainHandler
    extends Handler {
        private static final int PLUGIN_CONNECTED = 1;
        private static final int PLUGIN_DISCONNECTED = 2;

        public MainHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    PluginPrefs.setHasPlugins(PluginInstanceManager.this.mContext);
                    PluginInfo info = (PluginInfo)msg.obj;
                    PluginInstanceManager.this.mManager.handleWtfs();
                    if (!(msg.obj instanceof PluginFragment)) {
                        ((Plugin)info.mPlugin).onCreate(PluginInstanceManager.this.mContext, info.mPluginContext);
                    }
                    PluginInstanceManager.this.mListener.onPluginConnected((Plugin)info.mPlugin, info.mPluginContext);
                    break;
                }
                case 2: {
                    PluginInstanceManager.this.mListener.onPluginDisconnected((Plugin)msg.obj);
                    if (msg.obj instanceof PluginFragment) break;
                    ((Plugin)msg.obj).onDestroy();
                    break;
                }
                default: {
                    super.handleMessage(msg);
                }
            }
        }
    }
}

