/*
 * Decompiled with CFR 0.152.
 */
package com.android.systemui.shared.recents.model;

import android.util.ArrayMap;
import com.android.systemui.shared.recents.model.Task;
import com.android.systemui.shared.recents.model.TaskKeyCache;
import java.io.PrintWriter;

public class TaskKeyStrongCache<V>
extends TaskKeyCache<V> {
    private static final String TAG = "TaskKeyCache";
    private final ArrayMap<Integer, V> mCache = new ArrayMap();

    final void copyEntries(TaskKeyStrongCache<V> other) {
        for (int i = other.mKeys.size() - 1; i >= 0; --i) {
            Task.TaskKey key = (Task.TaskKey)other.mKeys.valueAt(i);
            this.put(key, other.mCache.get((Object)key.id));
        }
    }

    public void dump(String prefix, PrintWriter writer) {
        String innerPrefix = prefix + "  ";
        writer.print(prefix);
        writer.print(TAG);
        writer.print(" numEntries=");
        writer.print(this.mKeys.size());
        writer.println();
        int keyCount = this.mKeys.size();
        for (int i = 0; i < keyCount; ++i) {
            writer.print(innerPrefix);
            writer.println(this.mKeys.get(this.mKeys.keyAt(i)));
        }
    }

    @Override
    protected V getCacheEntry(int id2) {
        return (V)this.mCache.get((Object)id2);
    }

    @Override
    protected void putCacheEntry(int id2, V value) {
        this.mCache.put((Object)id2, value);
    }

    @Override
    protected void removeCacheEntry(int id2) {
        this.mCache.remove((Object)id2);
    }

    @Override
    protected void evictAllCache() {
        this.mCache.clear();
    }
}

