/*
 * Decompiled with CFR 0.152.
 */
package com.android.systemui.shared.recents.utilities;

import android.graphics.Color;
import android.os.Handler;
import android.os.Message;

public class Utilities {
    public static void postAtFrontOfQueueAsynchronously(Handler h, Runnable r) {
        Message msg = h.obtainMessage().setCallback(r);
        h.sendMessageAtFrontOfQueue(msg);
    }

    public static float computeContrastBetweenColors(int bg, int fg) {
        float bgR = (float)Color.red((int)bg) / 255.0f;
        float bgG = (float)Color.green((int)bg) / 255.0f;
        float bgB = (float)Color.blue((int)bg) / 255.0f;
        bgR = bgR < 0.03928f ? bgR / 12.92f : (float)Math.pow((bgR + 0.055f) / 1.055f, 2.4f);
        bgG = bgG < 0.03928f ? bgG / 12.92f : (float)Math.pow((bgG + 0.055f) / 1.055f, 2.4f);
        bgB = bgB < 0.03928f ? bgB / 12.92f : (float)Math.pow((bgB + 0.055f) / 1.055f, 2.4f);
        float bgL = 0.2126f * bgR + 0.7152f * bgG + 0.0722f * bgB;
        float fgR = (float)Color.red((int)fg) / 255.0f;
        float fgG = (float)Color.green((int)fg) / 255.0f;
        float fgB = (float)Color.blue((int)fg) / 255.0f;
        fgR = fgR < 0.03928f ? fgR / 12.92f : (float)Math.pow((fgR + 0.055f) / 1.055f, 2.4f);
        fgG = fgG < 0.03928f ? fgG / 12.92f : (float)Math.pow((fgG + 0.055f) / 1.055f, 2.4f);
        fgB = fgB < 0.03928f ? fgB / 12.92f : (float)Math.pow((fgB + 0.055f) / 1.055f, 2.4f);
        float fgL = 0.2126f * fgR + 0.7152f * fgG + 0.0722f * fgB;
        return Math.abs((fgL + 0.05f) / (bgL + 0.05f));
    }

    public static float clamp(float value, float min, float max) {
        return Math.max(min, Math.min(max, value));
    }
}

