/*
 * Decompiled with CFR 0.152.
 */
package com.android.systemui.shared.system;

import android.app.ActivityManager;
import android.app.ActivityOptions;
import android.app.AppGlobals;
import android.app.Application;
import android.app.IAssistDataReceiver;
import android.app.WindowConfiguration;
import android.content.ContentResolver;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.UserInfo;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.RemoteException;
import android.os.UserHandle;
import android.provider.Settings;
import android.util.Log;
import android.view.IRecentsAnimationController;
import android.view.IRecentsAnimationRunner;
import android.view.RemoteAnimationTarget;
import com.android.systemui.shared.recents.model.Task;
import com.android.systemui.shared.recents.model.ThumbnailData;
import com.android.systemui.shared.system.AssistDataReceiver;
import com.android.systemui.shared.system.BackgroundExecutor;
import com.android.systemui.shared.system.RecentsAnimationControllerCompat;
import com.android.systemui.shared.system.RecentsAnimationListener;
import com.android.systemui.shared.system.RemoteAnimationTargetCompat;
import com.android.systemui.shared.system.TaskStackChangeListener;
import com.android.systemui.shared.system.TaskStackChangeListeners;
import com.android.systemui.shared.system.WindowManagerWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class ActivityManagerWrapper {
    private static final String TAG = "ActivityManagerWrapper";
    private static final ActivityManagerWrapper sInstance = new ActivityManagerWrapper();
    private final PackageManager mPackageManager;
    private final BackgroundExecutor mBackgroundExecutor;
    private final TaskStackChangeListeners mTaskStackChangeListeners;

    private ActivityManagerWrapper() {
        Application context = AppGlobals.getInitialApplication();
        this.mPackageManager = context.getPackageManager();
        this.mBackgroundExecutor = BackgroundExecutor.get();
        this.mTaskStackChangeListeners = new TaskStackChangeListeners(Looper.getMainLooper());
    }

    public static ActivityManagerWrapper getInstance() {
        return sInstance;
    }

    public int getCurrentUserId() {
        try {
            UserInfo ui = ActivityManager.getService().getCurrentUser();
            return ui != null ? ui.id : 0;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public ActivityManager.RunningTaskInfo getRunningTask() {
        return this.getRunningTask(3);
    }

    public ActivityManager.RunningTaskInfo getRunningTask(@WindowConfiguration.ActivityType int ignoreActivityType) {
        try {
            List tasks = ActivityManager.getService().getFilteredTasks(1, ignoreActivityType, 2);
            if (tasks.isEmpty()) {
                return null;
            }
            return (ActivityManager.RunningTaskInfo)tasks.get(0);
        }
        catch (RemoteException e) {
            return null;
        }
    }

    public List<ActivityManager.RecentTaskInfo> getRecentTasks(int numTasks, int userId) {
        try {
            return ActivityManager.getService().getRecentTasks(numTasks, 2, userId).getList();
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)"Failed to get recent tasks", (Throwable)e);
            return new ArrayList<ActivityManager.RecentTaskInfo>();
        }
    }

    public ThumbnailData getTaskThumbnail(int taskId, boolean reducedResolution) {
        ActivityManager.TaskSnapshot snapshot = null;
        try {
            snapshot = ActivityManager.getService().getTaskSnapshot(taskId, reducedResolution);
        }
        catch (RemoteException e) {
            Log.w((String)TAG, (String)"Failed to retrieve task snapshot", (Throwable)e);
        }
        if (snapshot != null) {
            return new ThumbnailData(snapshot);
        }
        return new ThumbnailData();
    }

    public String getBadgedActivityLabel(ActivityInfo info, int userId) {
        return this.getBadgedLabel(info.loadLabel(this.mPackageManager).toString(), userId);
    }

    public String getBadgedApplicationLabel(ApplicationInfo appInfo, int userId) {
        return this.getBadgedLabel(appInfo.loadLabel(this.mPackageManager).toString(), userId);
    }

    public String getBadgedContentDescription(ActivityInfo info, int userId, ActivityManager.TaskDescription td) {
        String activityLabel = td != null && td.getLabel() != null ? td.getLabel() : info.loadLabel(this.mPackageManager).toString();
        String applicationLabel = info.applicationInfo.loadLabel(this.mPackageManager).toString();
        String badgedApplicationLabel = this.getBadgedLabel(applicationLabel, userId);
        return applicationLabel.equals(activityLabel) ? badgedApplicationLabel : badgedApplicationLabel + " " + activityLabel;
    }

    private String getBadgedLabel(String label, int userId) {
        if (userId != UserHandle.myUserId()) {
            label = this.mPackageManager.getUserBadgedLabel((CharSequence)label, new UserHandle(userId)).toString();
        }
        return label;
    }

    public void startRecentsActivity(Intent intent, final AssistDataReceiver assistDataReceiver, final RecentsAnimationListener animationHandler, final Consumer<Boolean> resultCallback, Handler resultCallbackHandler) {
        block5: {
            try {
                IAssistDataReceiver.Stub receiver = null;
                if (assistDataReceiver != null) {
                    receiver = new IAssistDataReceiver.Stub(){

                        public void onHandleAssistData(Bundle resultData) {
                            assistDataReceiver.onHandleAssistData(resultData);
                        }

                        public void onHandleAssistScreenshot(Bitmap screenshot) {
                            assistDataReceiver.onHandleAssistScreenshot(screenshot);
                        }
                    };
                }
                IRecentsAnimationRunner.Stub runner = null;
                if (animationHandler != null) {
                    runner = new IRecentsAnimationRunner.Stub(){

                        public void onAnimationStart(IRecentsAnimationController controller, RemoteAnimationTarget[] apps) {
                            Rect stableInsets = new Rect();
                            WindowManagerWrapper.getInstance().getStableInsets(stableInsets);
                            this.onAnimationStart_New(controller, apps, stableInsets, null);
                        }

                        public void onAnimationStart_New(IRecentsAnimationController controller, RemoteAnimationTarget[] apps, Rect homeContentInsets, Rect minimizedHomeBounds) {
                            RecentsAnimationControllerCompat controllerCompat = new RecentsAnimationControllerCompat(controller);
                            RemoteAnimationTargetCompat[] appsCompat = RemoteAnimationTargetCompat.wrap(apps);
                            animationHandler.onAnimationStart(controllerCompat, appsCompat, homeContentInsets, minimizedHomeBounds);
                        }

                        public void onAnimationCanceled() {
                            animationHandler.onAnimationCanceled();
                        }
                    };
                }
                ActivityManager.getService().startRecentsActivity(intent, (IAssistDataReceiver)receiver, runner);
                if (resultCallback != null) {
                    resultCallbackHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            resultCallback.accept(true);
                        }
                    });
                }
            }
            catch (Exception e) {
                if (resultCallback == null) break block5;
                resultCallbackHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        resultCallback.accept(false);
                    }
                });
            }
        }
    }

    public void cancelRecentsAnimation(boolean restoreHomeStackPosition) {
        try {
            ActivityManager.getService().cancelRecentsAnimation(restoreHomeStackPosition);
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)"Failed to cancel recents animation", (Throwable)e);
        }
    }

    public void startActivityFromRecentsAsync(Task.TaskKey taskKey, ActivityOptions options, Consumer<Boolean> resultCallback, Handler resultCallbackHandler) {
        this.startActivityFromRecentsAsync(taskKey, options, 0, 0, resultCallback, resultCallbackHandler);
    }

    public void startActivityFromRecentsAsync(final Task.TaskKey taskKey, ActivityOptions options, int windowingMode, int activityType, final Consumer<Boolean> resultCallback, final Handler resultCallbackHandler) {
        if (taskKey.windowingMode == 3) {
            if (options == null) {
                options = ActivityOptions.makeBasic();
            }
            options.setLaunchWindowingMode(4);
        } else if (windowingMode != 0 || activityType != 0) {
            if (options == null) {
                options = ActivityOptions.makeBasic();
            }
            options.setLaunchWindowingMode(windowingMode);
            options.setLaunchActivityType(activityType);
        }
        final ActivityOptions finalOptions = options;
        this.mBackgroundExecutor.submit(new Runnable(){

            @Override
            public void run() {
                boolean result = false;
                try {
                    result = ActivityManagerWrapper.this.startActivityFromRecents(taskKey.id, finalOptions);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                final boolean finalResult = result;
                if (resultCallback != null) {
                    resultCallbackHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            resultCallback.accept(finalResult);
                        }
                    });
                }
            }
        });
    }

    public boolean startActivityFromRecents(int taskId, ActivityOptions options) {
        try {
            Bundle optsBundle = options == null ? null : options.toBundle();
            ActivityManager.getService().startActivityFromRecents(taskId, optsBundle);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerTaskStackListener(TaskStackChangeListener listener) {
        TaskStackChangeListeners taskStackChangeListeners = this.mTaskStackChangeListeners;
        synchronized (taskStackChangeListeners) {
            this.mTaskStackChangeListeners.addListener(ActivityManager.getService(), listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterTaskStackListener(TaskStackChangeListener listener) {
        TaskStackChangeListeners taskStackChangeListeners = this.mTaskStackChangeListeners;
        synchronized (taskStackChangeListeners) {
            this.mTaskStackChangeListeners.removeListener(listener);
        }
    }

    public void closeSystemWindows(final String reason) {
        this.mBackgroundExecutor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    ActivityManager.getService().closeSystemDialogs(reason);
                }
                catch (RemoteException e) {
                    Log.w((String)ActivityManagerWrapper.TAG, (String)"Failed to close system windows", (Throwable)e);
                }
            }
        });
    }

    public void removeTask(final int taskId) {
        this.mBackgroundExecutor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    ActivityManager.getService().removeTask(taskId);
                }
                catch (RemoteException e) {
                    Log.w((String)ActivityManagerWrapper.TAG, (String)("Failed to remove task=" + taskId), (Throwable)e);
                }
            }
        });
    }

    public void cancelWindowTransition(int taskId) {
        try {
            ActivityManager.getService().cancelTaskWindowTransition(taskId);
        }
        catch (RemoteException e) {
            Log.w((String)TAG, (String)("Failed to cancel window transition for task=" + taskId), (Throwable)e);
        }
    }

    public boolean isScreenPinningActive() {
        try {
            return ActivityManager.getService().getLockTaskModeState() == 2;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public boolean isScreenPinningEnabled() {
        ContentResolver cr = AppGlobals.getInitialApplication().getContentResolver();
        return Settings.System.getInt((ContentResolver)cr, (String)"lock_to_app_enabled", (int)0) != 0;
    }

    public boolean isLockToAppActive() {
        try {
            return ActivityManager.getService().getLockTaskModeState() != 0;
        }
        catch (RemoteException e) {
            return false;
        }
    }
}

