/*
 * Copyright (C) 2018 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.android.launcher3.ui;

import android.app.Instrumentation;

import androidx.test.InstrumentationRegistry;
import androidx.test.uiautomator.UiDevice;

public class TestHelpers {
    private static final boolean IS_IN_LAUNCHER_PROCESS =
            getInstrumentation().getTargetContext().getPackageName().equals(
                    UiDevice.getInstance(getInstrumentation()).getLauncherPackageName());

    public static Instrumentation getInstrumentation() {
        return InstrumentationRegistry.getInstrumentation();
    }

    public static boolean isInLauncherProcess() {
        return IS_IN_LAUNCHER_PROCESS;
    }
}
