/*
 * Decompiled with CFR 0.152.
 */
package com.android.systemui.shared.recents.model;

import android.app.ActivityManager;
import android.app.ActivityTaskManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ActivityInfo;
import android.graphics.drawable.Drawable;
import android.os.Looper;
import android.os.Trace;
import android.util.LruCache;
import com.android.internal.annotations.GuardedBy;
import com.android.systemui.shared.recents.model.BackgroundTaskLoader;
import com.android.systemui.shared.recents.model.HighResThumbnailLoader;
import com.android.systemui.shared.recents.model.IconLoader;
import com.android.systemui.shared.recents.model.RecentsTaskLoadPlan;
import com.android.systemui.shared.recents.model.Task;
import com.android.systemui.shared.recents.model.TaskKeyLruCache;
import com.android.systemui.shared.recents.model.TaskKeyStrongCache;
import com.android.systemui.shared.recents.model.TaskResourceLoadQueue;
import com.android.systemui.shared.recents.model.ThumbnailData;
import com.android.systemui.shared.system.ActivityManagerWrapper;
import java.io.PrintWriter;
import java.util.Map;

@Deprecated
public class RecentsTaskLoader {
    private static final String TAG = "RecentsTaskLoader";
    private static final boolean DEBUG = false;
    public static final int SVELTE_NONE = 0;
    public static final int SVELTE_LIMIT_CACHE = 1;
    public static final int SVELTE_DISABLE_CACHE = 2;
    public static final int SVELTE_DISABLE_LOADING = 3;
    private final LruCache<ComponentName, ActivityInfo> mActivityInfoCache;
    private final TaskKeyLruCache<Drawable> mIconCache;
    private final TaskKeyLruCache<String> mActivityLabelCache;
    private final TaskKeyLruCache<String> mContentDescriptionCache;
    private final TaskResourceLoadQueue mLoadQueue;
    private final IconLoader mIconLoader;
    private final BackgroundTaskLoader mLoader;
    private final HighResThumbnailLoader mHighResThumbnailLoader;
    @GuardedBy(value={"this"})
    private final TaskKeyStrongCache<ThumbnailData> mThumbnailCache = new TaskKeyStrongCache();
    @GuardedBy(value={"this"})
    private final TaskKeyStrongCache<ThumbnailData> mTempCache = new TaskKeyStrongCache();
    private final int mMaxThumbnailCacheSize;
    private final int mMaxIconCacheSize;
    private int mNumVisibleTasksLoaded;
    private int mSvelteLevel;
    private int mDefaultTaskBarBackgroundColor;
    private int mDefaultTaskViewBackgroundColor;
    private TaskKeyLruCache.EvictionCallback mClearActivityInfoOnEviction = new TaskKeyLruCache.EvictionCallback(){

        @Override
        public void onEntryEvicted(Task.TaskKey key) {
            if (key != null) {
                RecentsTaskLoader.this.mActivityInfoCache.remove((Object)key.getComponent());
            }
        }
    };

    public RecentsTaskLoader(Context context, int maxThumbnailCacheSize, int maxIconCacheSize, int svelteLevel) {
        this.mMaxThumbnailCacheSize = maxThumbnailCacheSize;
        this.mMaxIconCacheSize = maxIconCacheSize;
        this.mSvelteLevel = svelteLevel;
        int numRecentTasks = ActivityTaskManager.getMaxRecentTasksStatic();
        this.mHighResThumbnailLoader = new HighResThumbnailLoader(ActivityManagerWrapper.getInstance(), Looper.getMainLooper(), ActivityManager.isLowRamDeviceStatic());
        this.mLoadQueue = new TaskResourceLoadQueue();
        this.mIconCache = new TaskKeyLruCache(this.mMaxIconCacheSize, this.mClearActivityInfoOnEviction);
        this.mActivityLabelCache = new TaskKeyLruCache(numRecentTasks, this.mClearActivityInfoOnEviction);
        this.mContentDescriptionCache = new TaskKeyLruCache(numRecentTasks, this.mClearActivityInfoOnEviction);
        this.mActivityInfoCache = new LruCache(numRecentTasks);
        this.mIconLoader = this.createNewIconLoader(context, this.mIconCache, this.mActivityInfoCache);
        this.mLoader = new BackgroundTaskLoader(this.mLoadQueue, this.mIconLoader, this.mHighResThumbnailLoader);
    }

    protected IconLoader createNewIconLoader(Context context, TaskKeyLruCache<Drawable> iconCache, LruCache<ComponentName, ActivityInfo> activityInfoCache) {
        return new IconLoader.DefaultIconLoader(context, iconCache, activityInfoCache);
    }

    public void setDefaultColors(int defaultTaskBarBackgroundColor, int defaultTaskViewBackgroundColor) {
        this.mDefaultTaskBarBackgroundColor = defaultTaskBarBackgroundColor;
        this.mDefaultTaskViewBackgroundColor = defaultTaskViewBackgroundColor;
    }

    public int getIconCacheSize() {
        return this.mMaxIconCacheSize;
    }

    public int getThumbnailCacheSize() {
        return this.mMaxThumbnailCacheSize;
    }

    public HighResThumbnailLoader getHighResThumbnailLoader() {
        return this.mHighResThumbnailLoader;
    }

    public synchronized void preloadTasks(RecentsTaskLoadPlan plan, int runningTaskId) {
        this.preloadTasks(plan, runningTaskId, ActivityManagerWrapper.getInstance().getCurrentUserId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void preloadTasks(RecentsTaskLoadPlan plan, int runningTaskId, int currentUserId) {
        try {
            Trace.beginSection((String)"preloadPlan");
            plan.preloadPlan(new RecentsTaskLoadPlan.PreloadOptions(), this, runningTaskId, currentUserId);
        }
        finally {
            Trace.endSection();
        }
    }

    public synchronized void loadTasks(RecentsTaskLoadPlan plan, RecentsTaskLoadPlan.Options opts) {
        if (opts == null) {
            throw new RuntimeException("Requires load options");
        }
        if (opts.onlyLoadForCache && opts.loadThumbnails) {
            this.mTempCache.copyEntries(this.mThumbnailCache);
            this.mThumbnailCache.evictAll();
        }
        plan.executePlan(opts, this);
        this.mTempCache.evictAll();
        if (!opts.onlyLoadForCache) {
            this.mNumVisibleTasksLoaded = opts.numVisibleTasks;
        }
    }

    public void loadTaskData(Task t) {
        Drawable icon = (Drawable)this.mIconCache.getAndInvalidateIfModified(t.key);
        icon = icon != null ? icon : this.mIconLoader.getDefaultIcon(t.key.userId);
        this.mLoadQueue.addTask(t);
        t.notifyTaskDataLoaded(t.thumbnail, icon);
    }

    public void unloadTaskData(Task t) {
        this.mLoadQueue.removeTask(t);
        t.notifyTaskDataUnloaded(this.mIconLoader.getDefaultIcon(t.key.userId));
    }

    public void deleteTaskData(Task t, boolean notifyTaskDataUnloaded) {
        this.mLoadQueue.removeTask(t);
        this.mIconCache.remove(t.key);
        this.mActivityLabelCache.remove(t.key);
        this.mContentDescriptionCache.remove(t.key);
        if (notifyTaskDataUnloaded) {
            t.notifyTaskDataUnloaded(this.mIconLoader.getDefaultIcon(t.key.userId));
        }
    }

    public synchronized void onTrimMemory(int level) {
        switch (level) {
            case 20: {
                this.stopLoader();
                this.mIconCache.trimToSize(Math.max(this.mNumVisibleTasksLoaded, this.mMaxIconCacheSize / 2));
                break;
            }
            case 5: 
            case 40: {
                this.mIconCache.trimToSize(Math.max(1, this.mMaxIconCacheSize / 2));
                this.mActivityInfoCache.trimToSize(Math.max(1, ActivityTaskManager.getMaxRecentTasksStatic() / 2));
                break;
            }
            case 10: 
            case 60: {
                this.mIconCache.trimToSize(Math.max(1, this.mMaxIconCacheSize / 4));
                this.mActivityInfoCache.trimToSize(Math.max(1, ActivityTaskManager.getMaxRecentTasksStatic() / 4));
                break;
            }
            case 15: 
            case 80: {
                this.mIconCache.evictAll();
                this.mActivityInfoCache.evictAll();
                this.mActivityLabelCache.evictAll();
                this.mContentDescriptionCache.evictAll();
                this.mThumbnailCache.evictAll();
                break;
            }
        }
    }

    public void onPackageChanged(String packageName) {
        Map activityInfoCache = this.mActivityInfoCache.snapshot();
        for (ComponentName cn : activityInfoCache.keySet()) {
            if (!cn.getPackageName().equals(packageName)) continue;
            this.mActivityInfoCache.remove((Object)cn);
        }
    }

    String getAndUpdateActivityTitle(Task.TaskKey taskKey, ActivityManager.TaskDescription td) {
        if (td != null && td.getLabel() != null) {
            return td.getLabel();
        }
        String label = (String)this.mActivityLabelCache.getAndInvalidateIfModified(taskKey);
        if (label != null) {
            return label;
        }
        ActivityInfo activityInfo = this.getAndUpdateActivityInfo(taskKey);
        if (activityInfo != null) {
            label = ActivityManagerWrapper.getInstance().getBadgedActivityLabel(activityInfo, taskKey.userId);
            this.mActivityLabelCache.put(taskKey, label);
            return label;
        }
        return "";
    }

    String getAndUpdateContentDescription(Task.TaskKey taskKey, ActivityManager.TaskDescription td) {
        String label = (String)this.mContentDescriptionCache.getAndInvalidateIfModified(taskKey);
        if (label != null) {
            return label;
        }
        ActivityInfo activityInfo = this.getAndUpdateActivityInfo(taskKey);
        if (activityInfo != null) {
            label = ActivityManagerWrapper.getInstance().getBadgedContentDescription(activityInfo, taskKey.userId, td);
            if (td == null) {
                this.mContentDescriptionCache.put(taskKey, label);
            }
            return label;
        }
        return "";
    }

    Drawable getAndUpdateActivityIcon(Task.TaskKey taskKey, ActivityManager.TaskDescription td, boolean loadIfNotCached) {
        return this.mIconLoader.getAndInvalidateIfModified(taskKey, td, loadIfNotCached);
    }

    synchronized ThumbnailData getAndUpdateThumbnail(Task.TaskKey taskKey, boolean loadIfNotCached, boolean storeInCache) {
        ThumbnailData cached = (ThumbnailData)this.mThumbnailCache.getAndInvalidateIfModified(taskKey);
        if (cached != null) {
            return cached;
        }
        cached = (ThumbnailData)this.mTempCache.getAndInvalidateIfModified(taskKey);
        if (cached != null) {
            this.mThumbnailCache.put(taskKey, cached);
            return cached;
        }
        if (loadIfNotCached && this.mSvelteLevel < 3) {
            ThumbnailData thumbnailData = ActivityManagerWrapper.getInstance().getTaskThumbnail(taskKey.id, true);
            if (thumbnailData.thumbnail != null) {
                if (storeInCache) {
                    this.mThumbnailCache.put(taskKey, thumbnailData);
                }
                return thumbnailData;
            }
        }
        return null;
    }

    int getActivityPrimaryColor(ActivityManager.TaskDescription td) {
        if (td != null && td.getPrimaryColor() != 0) {
            return td.getPrimaryColor();
        }
        return this.mDefaultTaskBarBackgroundColor;
    }

    int getActivityBackgroundColor(ActivityManager.TaskDescription td) {
        if (td != null && td.getBackgroundColor() != 0) {
            return td.getBackgroundColor();
        }
        return this.mDefaultTaskViewBackgroundColor;
    }

    ActivityInfo getAndUpdateActivityInfo(Task.TaskKey taskKey) {
        return this.mIconLoader.getAndUpdateActivityInfo(taskKey);
    }

    public void startLoader(Context ctx) {
        this.mLoader.start(ctx);
    }

    private void stopLoader() {
        this.mLoader.stop();
        this.mLoadQueue.clearTasks();
    }

    public synchronized void dump(String prefix, PrintWriter writer) {
        String innerPrefix = prefix + "  ";
        writer.print(prefix);
        writer.println(TAG);
        writer.print(prefix);
        writer.println("Icon Cache");
        this.mIconCache.dump(innerPrefix, writer);
        writer.print(prefix);
        writer.println("Thumbnail Cache");
        this.mThumbnailCache.dump(innerPrefix, writer);
        writer.print(prefix);
        writer.println("Temp Thumbnail Cache");
        this.mTempCache.dump(innerPrefix, writer);
    }
}

