/*
 * Decompiled with CFR 0.152.
 */
package com.android.systemui.shared.recents.model;

import android.util.ArrayMap;
import android.util.SparseArray;
import com.android.systemui.shared.recents.model.Task;
import com.android.systemui.shared.recents.model.TaskFilter;
import java.util.ArrayList;
import java.util.List;

@Deprecated
class FilteredTaskList {
    private final ArrayList<Task> mTasks = new ArrayList();
    private final ArrayList<Task> mFilteredTasks = new ArrayList();
    private final ArrayMap<Task.TaskKey, Integer> mFilteredTaskIndices = new ArrayMap();
    private TaskFilter mFilter;

    FilteredTaskList() {
    }

    boolean setFilter(TaskFilter filter) {
        ArrayList<Task> prevFilteredTasks = new ArrayList<Task>(this.mFilteredTasks);
        this.mFilter = filter;
        this.updateFilteredTasks();
        return !prevFilteredTasks.equals(this.mFilteredTasks);
    }

    void add(Task t) {
        this.mTasks.add(t);
        this.updateFilteredTasks();
    }

    void set(List<Task> tasks) {
        this.mTasks.clear();
        this.mTasks.addAll(tasks);
        this.updateFilteredTasks();
    }

    boolean remove(Task t) {
        if (this.mFilteredTasks.contains(t)) {
            boolean removed = this.mTasks.remove(t);
            this.updateFilteredTasks();
            return removed;
        }
        return false;
    }

    int indexOf(Task t) {
        if (t != null && this.mFilteredTaskIndices.containsKey((Object)t.key)) {
            return (Integer)this.mFilteredTaskIndices.get((Object)t.key);
        }
        return -1;
    }

    int size() {
        return this.mFilteredTasks.size();
    }

    boolean contains(Task t) {
        return this.mFilteredTaskIndices.containsKey((Object)t.key);
    }

    private void updateFilteredTasks() {
        this.mFilteredTasks.clear();
        if (this.mFilter != null) {
            Task t;
            int i;
            SparseArray taskIdMap = new SparseArray();
            int taskCount = this.mTasks.size();
            for (i = 0; i < taskCount; ++i) {
                t = this.mTasks.get(i);
                taskIdMap.put(t.key.id, (Object)t);
            }
            for (i = 0; i < taskCount; ++i) {
                t = this.mTasks.get(i);
                if (!this.mFilter.acceptTask((SparseArray<Task>)taskIdMap, t, i)) continue;
                this.mFilteredTasks.add(t);
            }
        } else {
            this.mFilteredTasks.addAll(this.mTasks);
        }
        this.updateFilteredTaskIndices();
    }

    private void updateFilteredTaskIndices() {
        int taskCount = this.mFilteredTasks.size();
        this.mFilteredTaskIndices.clear();
        for (int i = 0; i < taskCount; ++i) {
            Task t = this.mFilteredTasks.get(i);
            this.mFilteredTaskIndices.put((Object)t.key, (Object)i);
        }
    }

    ArrayList<Task> getTasks() {
        return this.mFilteredTasks;
    }
}

