/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf.nano.android;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.protobuf.nano.InvalidProtocolBufferNanoException;
import com.google.protobuf.nano.MessageNano;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;

public final class ParcelableMessageNanoCreator<T extends MessageNano>
implements Parcelable.Creator<T> {
    private static final String TAG = "PMNCreator";
    private final Class<T> mClazz;

    public ParcelableMessageNanoCreator(Class<T> clazz) {
        this.mClazz = clazz;
    }

    public T createFromParcel(Parcel in) {
        String className = in.readString();
        byte[] data = in.createByteArray();
        MessageNano proto = null;
        try {
            MessageNano instance;
            Class<MessageNano> clazz = Class.forName(className, false, this.getClass().getClassLoader()).asSubclass(MessageNano.class);
            proto = instance = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            MessageNano.mergeFrom(proto, data);
        }
        catch (ClassNotFoundException e) {
            Log.e((String)TAG, (String)"Exception trying to create proto from parcel", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            Log.e((String)TAG, (String)"Exception trying to create proto from parcel", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            Log.e((String)TAG, (String)"Exception trying to create proto from parcel", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            Log.e((String)TAG, (String)"Exception trying to create proto from parcel", (Throwable)e);
        }
        catch (InstantiationException e) {
            Log.e((String)TAG, (String)"Exception trying to create proto from parcel", (Throwable)e);
        }
        catch (InvalidProtocolBufferNanoException e) {
            Log.e((String)TAG, (String)"Exception trying to create proto from parcel", (Throwable)e);
        }
        return (T)proto;
    }

    public T[] newArray(int i) {
        return (MessageNano[])Array.newInstance(this.mClazz, i);
    }

    static <T extends MessageNano> void writeToParcel(Class<T> clazz, MessageNano message, Parcel out) {
        out.writeString(clazz.getName());
        out.writeByteArray(MessageNano.toByteArray(message));
    }
}

