/*
 * Decompiled with CFR 0.152.
 */
package com.android.systemui.shared.recents.view;

import android.graphics.Outline;
import android.graphics.Rect;
import android.view.View;
import android.view.ViewOutlineProvider;
import com.android.systemui.shared.recents.utilities.Utilities;

public class AnimateableViewBounds
extends ViewOutlineProvider {
    private static final float MIN_ALPHA = 0.1f;
    private static final float MAX_ALPHA = 0.8f;
    protected View mSourceView;
    protected Rect mClipRect = new Rect();
    protected Rect mClipBounds = new Rect();
    protected Rect mLastClipBounds = new Rect();
    protected int mCornerRadius;
    protected float mAlpha = 1.0f;

    public AnimateableViewBounds(View source, int cornerRadius) {
        this.mSourceView = source;
        this.mCornerRadius = cornerRadius;
    }

    public void reset() {
        this.mClipRect.set(0, 0, 0, 0);
        this.updateClipBounds();
    }

    public void getOutline(View view, Outline outline) {
        outline.setAlpha(Utilities.mapRange(this.mAlpha, 0.1f, 0.8f));
        if (this.mCornerRadius > 0) {
            outline.setRoundRect(this.mClipRect.left, this.mClipRect.top, this.mSourceView.getWidth() - this.mClipRect.right, this.mSourceView.getHeight() - this.mClipRect.bottom, (float)this.mCornerRadius);
        } else {
            outline.setRect(this.mClipRect.left, this.mClipRect.top, this.mSourceView.getWidth() - this.mClipRect.right, this.mSourceView.getHeight() - this.mClipRect.bottom);
        }
    }

    public void setAlpha(float alpha) {
        if (Float.compare(alpha, this.mAlpha) != 0) {
            this.mAlpha = alpha;
            this.mSourceView.invalidateOutline();
        }
    }

    public float getAlpha() {
        return this.mAlpha;
    }

    public void setClipTop(int top) {
        this.mClipRect.top = top;
        this.updateClipBounds();
    }

    public int getClipTop() {
        return this.mClipRect.top;
    }

    public void setClipBottom(int bottom) {
        this.mClipRect.bottom = bottom;
        this.updateClipBounds();
    }

    public int getClipBottom() {
        return this.mClipRect.bottom;
    }

    protected void updateClipBounds() {
        this.mClipBounds.set(Math.max(0, this.mClipRect.left), Math.max(0, this.mClipRect.top), this.mSourceView.getWidth() - Math.max(0, this.mClipRect.right), this.mSourceView.getHeight() - Math.max(0, this.mClipRect.bottom));
        if (!this.mLastClipBounds.equals((Object)this.mClipBounds)) {
            this.mSourceView.setClipBounds(this.mClipBounds);
            this.mSourceView.invalidateOutline();
            this.mLastClipBounds.set(this.mClipBounds);
        }
    }
}

