/*
 * Decompiled with CFR 0.152.
 */
package com.android.systemui.shared.recents.model;

import android.app.ActivityManager;
import android.app.KeyguardManager;
import android.content.Context;
import android.content.pm.ActivityInfo;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.util.SparseBooleanArray;
import com.android.systemui.shared.recents.model.RecentsTaskLoader;
import com.android.systemui.shared.recents.model.Task;
import com.android.systemui.shared.recents.model.TaskStack;
import com.android.systemui.shared.recents.model.ThumbnailData;
import com.android.systemui.shared.system.ActivityManagerWrapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RecentsTaskLoadPlan {
    private final Context mContext;
    private final KeyguardManager mKeyguardManager;
    private List<ActivityManager.RecentTaskInfo> mRawTasks;
    private TaskStack mStack;
    private final SparseBooleanArray mTmpLockedUsers = new SparseBooleanArray();

    public RecentsTaskLoadPlan(Context context) {
        this.mContext = context;
        this.mKeyguardManager = (KeyguardManager)context.getSystemService("keyguard");
    }

    public void preloadPlan(PreloadOptions opts, RecentsTaskLoader loader, int runningTaskId, int currentUserId) {
        Resources res = this.mContext.getResources();
        ArrayList<Task> allTasks = new ArrayList<Task>();
        if (this.mRawTasks == null) {
            this.mRawTasks = ActivityManagerWrapper.getInstance().getRecentTasks(ActivityManager.getMaxRecentTasksStatic(), currentUserId);
            Collections.reverse(this.mRawTasks);
        }
        int taskCount = this.mRawTasks.size();
        for (int i = 0; i < taskCount; ++i) {
            boolean isSystemApp;
            ActivityManager.RecentTaskInfo t = this.mRawTasks.get(i);
            int windowingMode = t.configuration.windowConfiguration.getWindowingMode();
            Task.TaskKey taskKey = new Task.TaskKey(t.persistentId, windowingMode, t.baseIntent, t.userId, t.lastActiveTime);
            boolean isFreeformTask = windowingMode == 5;
            boolean isStackTask = !isFreeformTask;
            boolean isLaunchTarget = taskKey.id == runningTaskId;
            ActivityInfo info = loader.getAndUpdateActivityInfo(taskKey);
            if (info == null) continue;
            String title = opts.loadTitles ? loader.getAndUpdateActivityTitle(taskKey, t.taskDescription) : "";
            String titleDescription = opts.loadTitles ? loader.getAndUpdateContentDescription(taskKey, t.taskDescription) : "";
            Drawable icon = isStackTask ? loader.getAndUpdateActivityIcon(taskKey, t.taskDescription, false) : null;
            ThumbnailData thumbnail = loader.getAndUpdateThumbnail(taskKey, false, false);
            int activityColor = loader.getActivityPrimaryColor(t.taskDescription);
            int backgroundColor = loader.getActivityBackgroundColor(t.taskDescription);
            boolean bl = isSystemApp = info != null && (info.applicationInfo.flags & 1) != 0;
            if (this.mTmpLockedUsers.indexOfKey(t.userId) < 0) {
                this.mTmpLockedUsers.put(t.userId, this.mKeyguardManager.isDeviceLocked(t.userId));
            }
            boolean isLocked = this.mTmpLockedUsers.get(t.userId);
            Task task = new Task(taskKey, icon, thumbnail, title, titleDescription, activityColor, backgroundColor, isLaunchTarget, isStackTask, isSystemApp, t.supportsSplitScreenMultiWindow, t.taskDescription, t.resizeMode, t.topActivity, isLocked);
            allTasks.add(task);
        }
        this.mStack = new TaskStack();
        this.mStack.setTasks(allTasks, false);
    }

    public void executePlan(Options opts, RecentsTaskLoader loader) {
        Resources res = this.mContext.getResources();
        ArrayList<Task> tasks = this.mStack.getTasks();
        int taskCount = tasks.size();
        for (int i = 0; i < taskCount; ++i) {
            boolean isVisibleThumbnail;
            Task task = tasks.get(i);
            Task.TaskKey taskKey = task.key;
            boolean isRunningTask = task.key.id == opts.runningTaskId;
            boolean isVisibleTask = i >= taskCount - opts.numVisibleTasks;
            boolean bl = isVisibleThumbnail = i >= taskCount - opts.numVisibleTaskThumbnails;
            if (opts.onlyLoadPausedActivities && isRunningTask) continue;
            if (opts.loadIcons && (isRunningTask || isVisibleTask) && task.icon == null) {
                task.icon = loader.getAndUpdateActivityIcon(taskKey, task.taskDescription, true);
            }
            if (!opts.loadThumbnails || !isVisibleThumbnail) continue;
            task.thumbnail = loader.getAndUpdateThumbnail(taskKey, true, true);
        }
    }

    public TaskStack getTaskStack() {
        return this.mStack;
    }

    public boolean hasTasks() {
        if (this.mStack != null) {
            return this.mStack.getTaskCount() > 0;
        }
        return false;
    }

    public static class Options {
        public int runningTaskId = -1;
        public boolean loadIcons = true;
        public boolean loadThumbnails = false;
        public boolean onlyLoadForCache = false;
        public boolean onlyLoadPausedActivities = false;
        public int numVisibleTasks = 0;
        public int numVisibleTaskThumbnails = 0;
    }

    public static class PreloadOptions {
        public boolean loadTitles = true;
    }
}

