/*
 * Copyright (C) 2018 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.android.launcher3.allapps;

import android.content.Context;
import android.util.AttributeSet;

import com.android.launcher3.PagedView;
import com.android.launcher3.R;
import com.android.launcher3.config.FeatureFlags;
import com.android.launcher3.workprofile.PersonalWorkPagedView;

/**
 *  A {@link PagedView} for showing different views for the personal and work profile respectively
 *  in the {@link AllAppsContainerView}.
 */
public class AllAppsPagedView extends PersonalWorkPagedView {

    public AllAppsPagedView(Context context) {
        this(context, null);
    }

    public AllAppsPagedView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public AllAppsPagedView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        int topPadding = FeatureFlags.ENABLE_DEVICE_SEARCH.get() ? 0
                : context.getResources().getDimensionPixelOffset(
                        R.dimen.all_apps_header_top_padding);
        setPadding(0, topPadding, 0, 0);
    }
}
