/*
 * Decompiled with CFR 0.152.
 */
package com.android.systemui.shared.system;

import android.os.Bundle;
import android.os.Looper;
import android.util.Pair;
import android.view.BatchedInputEventReceiver;
import android.view.Choreographer;
import android.view.InputChannel;
import android.view.InputEvent;
import android.view.InputEventSender;
import android.view.MotionEvent;

public class InputChannelCompat {
    public static Pair<InputEventDispatcher, InputEventReceiver> createPair(String name, Looper looper, Choreographer choreographer, InputEventListener listener) {
        InputChannel[] channels = InputChannel.openInputChannelPair((String)name);
        InputEventDispatcher dispatcher = new InputEventDispatcher(channels[0], looper);
        InputEventReceiver receiver = new InputEventReceiver(channels[1], looper, choreographer, listener);
        return Pair.create((Object)dispatcher, (Object)receiver);
    }

    public static InputEventReceiver fromBundle(Bundle params, String key, Looper looper, Choreographer choreographer, InputEventListener listener) {
        InputChannel channel = (InputChannel)params.getParcelable(key);
        return new InputEventReceiver(channel, looper, choreographer, listener);
    }

    public static boolean mergeMotionEvent(MotionEvent src, MotionEvent target) {
        return target.addBatch(src);
    }

    public static class InputEventDispatcher {
        private final InputChannel mInputChannel;
        private final InputEventSender mSender;

        public InputEventDispatcher(InputChannel inputChannel, Looper looper) {
            this.mInputChannel = inputChannel;
            this.mSender = new InputEventSender(inputChannel, looper){};
        }

        public void dispatch(InputEvent ev) {
            this.mSender.sendInputEvent(ev.getSequenceNumber(), ev);
        }

        public void dispose() {
            this.mSender.dispose();
            this.mInputChannel.dispose();
        }
    }

    public static class InputEventReceiver {
        private final BatchedInputEventReceiver mReceiver;
        private final InputChannel mInputChannel;

        public InputEventReceiver(InputChannel inputChannel, Looper looper, Choreographer choreographer, final InputEventListener listener) {
            this.mInputChannel = inputChannel;
            this.mReceiver = new BatchedInputEventReceiver(inputChannel, looper, choreographer){

                public void onInputEvent(InputEvent event) {
                    listener.onInputEvent(event);
                    this.finishInputEvent(event, true);
                }
            };
        }

        public void dispose() {
            this.mReceiver.dispose();
            this.mInputChannel.dispose();
        }
    }

    public static interface InputEventListener {
        public void onInputEvent(InputEvent var1);
    }
}

