/*
 * Decompiled with CFR 0.152.
 */
package com.android.systemui.shared.recents.model;

import android.util.LruCache;
import com.android.systemui.shared.recents.model.Task;
import com.android.systemui.shared.recents.model.TaskKeyCache;
import java.io.PrintWriter;

public class TaskKeyLruCache<V>
extends TaskKeyCache<V> {
    private final LruCache<Integer, V> mCache;
    private final EvictionCallback mEvictionCallback;

    public TaskKeyLruCache(int cacheSize) {
        this(cacheSize, null);
    }

    public TaskKeyLruCache(int cacheSize, EvictionCallback evictionCallback) {
        this.mEvictionCallback = evictionCallback;
        this.mCache = new LruCache<Integer, V>(cacheSize){

            protected void entryRemoved(boolean evicted, Integer taskId, V oldV, V newV) {
                if (TaskKeyLruCache.this.mEvictionCallback != null) {
                    TaskKeyLruCache.this.mEvictionCallback.onEntryEvicted((Task.TaskKey)TaskKeyLruCache.this.mKeys.get(taskId.intValue()));
                }
                TaskKeyLruCache.this.mKeys.remove(taskId.intValue());
            }
        };
    }

    public final void trimToSize(int cacheSize) {
        this.mCache.trimToSize(cacheSize);
    }

    public void dump(String prefix, PrintWriter writer) {
        String innerPrefix = prefix + "  ";
        writer.print(prefix);
        writer.print("TaskKeyCache");
        writer.print(" numEntries=");
        writer.print(this.mKeys.size());
        writer.println();
        int keyCount = this.mKeys.size();
        for (int i = 0; i < keyCount; ++i) {
            writer.print(innerPrefix);
            writer.println(this.mKeys.get(this.mKeys.keyAt(i)));
        }
    }

    @Override
    protected V getCacheEntry(int id) {
        return (V)this.mCache.get((Object)id);
    }

    @Override
    protected void putCacheEntry(int id, V value) {
        this.mCache.put((Object)id, value);
    }

    @Override
    protected void removeCacheEntry(int id) {
        this.mCache.remove((Object)id);
    }

    @Override
    protected void evictAllCache() {
        this.mCache.evictAll();
    }

    public static interface EvictionCallback {
        public void onEntryEvicted(Task.TaskKey var1);
    }
}

