/*
 * Decompiled with CFR 0.152.
 */
package com.android.systemui.shared.recents.model;

import android.app.ActivityManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageItemInfo;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.UserHandle;
import android.util.IconDrawableFactory;
import android.util.Log;
import android.util.LruCache;
import com.android.systemui.shared.recents.model.Task;
import com.android.systemui.shared.recents.model.TaskKeyLruCache;
import com.android.systemui.shared.system.PackageManagerWrapper;

public abstract class IconLoader {
    private static final String TAG = "IconLoader";
    protected final Context mContext;
    protected final TaskKeyLruCache<Drawable> mIconCache;
    protected final LruCache<ComponentName, ActivityInfo> mActivityInfoCache;

    public IconLoader(Context context, TaskKeyLruCache<Drawable> iconCache, LruCache<ComponentName, ActivityInfo> activityInfoCache) {
        this.mContext = context;
        this.mIconCache = iconCache;
        this.mActivityInfoCache = activityInfoCache;
    }

    public ActivityInfo getAndUpdateActivityInfo(Task.TaskKey taskKey) {
        ComponentName cn = taskKey.getComponent();
        ActivityInfo activityInfo = (ActivityInfo)this.mActivityInfoCache.get((Object)cn);
        if (activityInfo == null) {
            activityInfo = PackageManagerWrapper.getInstance().getActivityInfo(cn, taskKey.userId);
            if (cn == null || activityInfo == null) {
                Log.e((String)TAG, (String)("Unexpected null component name or activity info: " + cn + ", " + activityInfo));
                return null;
            }
            this.mActivityInfoCache.put((Object)cn, (Object)activityInfo);
        }
        return activityInfo;
    }

    public Drawable getIcon(Task t) {
        Drawable cachedIcon = (Drawable)this.mIconCache.get(t.key);
        if (cachedIcon == null) {
            cachedIcon = this.createNewIconForTask(t.key, t.taskDescription, true);
            this.mIconCache.put(t.key, cachedIcon);
        }
        return cachedIcon;
    }

    public Drawable getAndInvalidateIfModified(Task.TaskKey taskKey, ActivityManager.TaskDescription td, boolean loadIfNotCached) {
        Drawable icon = (Drawable)this.mIconCache.getAndInvalidateIfModified(taskKey);
        if (icon != null) {
            return icon;
        }
        if (loadIfNotCached && (icon = this.createNewIconForTask(taskKey, td, false)) != null) {
            this.mIconCache.put(taskKey, icon);
            return icon;
        }
        return null;
    }

    private Drawable createNewIconForTask(Task.TaskKey taskKey, ActivityManager.TaskDescription desc, boolean returnDefault) {
        Drawable icon;
        int userId = taskKey.userId;
        Bitmap tdIcon = desc.getInMemoryIcon();
        if (tdIcon != null) {
            return this.createDrawableFromBitmap(tdIcon, userId, desc);
        }
        if (desc.getIconResource() != 0) {
            try {
                return this.createBadgedDrawable(this.mContext.getDrawable(desc.getIconResource()), userId, desc);
            }
            catch (Resources.NotFoundException e) {
                Log.e((String)TAG, (String)"Could not find icon drawable from resource", (Throwable)e);
            }
        }
        if ((tdIcon = ActivityManager.TaskDescription.loadTaskDescriptionIcon((String)desc.getIconFilename(), (int)userId)) != null) {
            return this.createDrawableFromBitmap(tdIcon, userId, desc);
        }
        ActivityInfo activityInfo = this.getAndUpdateActivityInfo(taskKey);
        if (activityInfo != null && (icon = this.getBadgedActivityIcon(activityInfo, userId, desc)) != null) {
            return icon;
        }
        return returnDefault ? this.getDefaultIcon(userId) : null;
    }

    public abstract Drawable getDefaultIcon(int var1);

    protected Drawable createDrawableFromBitmap(Bitmap icon, int userId, ActivityManager.TaskDescription desc) {
        return this.createBadgedDrawable((Drawable)new BitmapDrawable(this.mContext.getResources(), icon), userId, desc);
    }

    protected abstract Drawable createBadgedDrawable(Drawable var1, int var2, ActivityManager.TaskDescription var3);

    protected abstract Drawable getBadgedActivityIcon(ActivityInfo var1, int var2, ActivityManager.TaskDescription var3);

    public static class DefaultIconLoader
    extends IconLoader {
        private final BitmapDrawable mDefaultIcon;
        private final IconDrawableFactory mDrawableFactory;

        public DefaultIconLoader(Context context, TaskKeyLruCache<Drawable> iconCache, LruCache<ComponentName, ActivityInfo> activityInfoCache) {
            super(context, iconCache, activityInfoCache);
            Bitmap icon = Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)Bitmap.Config.ALPHA_8);
            icon.eraseColor(0);
            this.mDefaultIcon = new BitmapDrawable(context.getResources(), icon);
            this.mDrawableFactory = IconDrawableFactory.newInstance((Context)context);
        }

        @Override
        public Drawable getDefaultIcon(int userId) {
            return this.mDefaultIcon;
        }

        @Override
        protected Drawable createBadgedDrawable(Drawable icon, int userId, ActivityManager.TaskDescription desc) {
            if (userId != UserHandle.myUserId()) {
                icon = this.mContext.getPackageManager().getUserBadgedIcon(icon, new UserHandle(userId));
            }
            return icon;
        }

        @Override
        protected Drawable getBadgedActivityIcon(ActivityInfo info, int userId, ActivityManager.TaskDescription desc) {
            return this.mDrawableFactory.getBadgedIcon((PackageItemInfo)info, info.applicationInfo, userId);
        }
    }
}

