/*
 * Decompiled with CFR 0.152.
 */
package com.android.systemui.shared.recents.view;

import android.os.Handler;
import android.os.Looper;
import android.os.RemoteException;
import android.view.AppTransitionAnimationSpec;
import android.view.IAppTransitionAnimationSpecsFuture;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;

public abstract class AppTransitionAnimationSpecsFuture {
    private final Handler mHandler;
    private FutureTask<List<AppTransitionAnimationSpec>> mComposeTask = new FutureTask<List<AppTransitionAnimationSpec>>(new Callable<List<AppTransitionAnimationSpec>>(){

        @Override
        public List<AppTransitionAnimationSpec> call() throws Exception {
            return AppTransitionAnimationSpecsFuture.this.composeSpecs();
        }
    });
    private final IAppTransitionAnimationSpecsFuture mFuture = new IAppTransitionAnimationSpecsFuture.Stub(){

        public AppTransitionAnimationSpec[] get() throws RemoteException {
            try {
                List specs;
                if (!AppTransitionAnimationSpecsFuture.this.mComposeTask.isDone()) {
                    AppTransitionAnimationSpecsFuture.this.mHandler.post((Runnable)AppTransitionAnimationSpecsFuture.this.mComposeTask);
                }
                if ((specs = (List)AppTransitionAnimationSpecsFuture.this.mComposeTask.get()) == null) {
                    return null;
                }
                AppTransitionAnimationSpec[] arr = new AppTransitionAnimationSpec[specs.size()];
                specs.toArray(arr);
                return arr;
            }
            catch (Exception e) {
                return null;
            }
        }
    };

    public AppTransitionAnimationSpecsFuture(Handler handler) {
        this.mHandler = handler;
    }

    public final IAppTransitionAnimationSpecsFuture getFuture() {
        return this.mFuture;
    }

    public final void composeSpecsSynchronous() {
        if (Looper.myLooper() != this.mHandler.getLooper()) {
            throw new RuntimeException("composeSpecsSynchronous() called from wrong looper");
        }
        this.mComposeTask.run();
    }

    public abstract List<AppTransitionAnimationSpec> composeSpecs();
}

