/*
 * Decompiled with CFR 0.152.
 */
package com.android.systemui.shared.recents.model;

import android.os.Handler;
import android.os.Looper;
import android.os.Process;
import android.os.SystemClock;
import android.util.ArraySet;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.systemui.shared.recents.model.Task;
import com.android.systemui.shared.recents.model.ThumbnailData;
import com.android.systemui.shared.system.ActivityManagerWrapper;
import java.util.ArrayDeque;
import java.util.ArrayList;

public class HighResThumbnailLoader
implements Task.TaskCallbacks {
    private final ActivityManagerWrapper mActivityManager;
    @GuardedBy(value={"mLoadQueue"})
    private final ArrayDeque<Task> mLoadQueue = new ArrayDeque();
    @GuardedBy(value={"mLoadQueue"})
    private final ArraySet<Task> mLoadingTasks = new ArraySet();
    @GuardedBy(value={"mLoadQueue"})
    private boolean mLoaderIdling;
    private final ArrayList<Task> mVisibleTasks = new ArrayList();
    private final Thread mLoadThread;
    private final Handler mMainThreadHandler;
    private final boolean mIsLowRamDevice;
    private boolean mLoading;
    private boolean mVisible;
    private boolean mFlingingFast;
    private boolean mTaskLoadQueueIdle;
    private final Runnable mLoader = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Process.setThreadPriority((int)11);
            while (true) {
                Task next = null;
                ArrayDeque arrayDeque = HighResThumbnailLoader.this.mLoadQueue;
                synchronized (arrayDeque) {
                    if (!HighResThumbnailLoader.this.mLoading || HighResThumbnailLoader.this.mLoadQueue.isEmpty()) {
                        try {
                            HighResThumbnailLoader.this.mLoaderIdling = true;
                            HighResThumbnailLoader.this.mLoadQueue.wait();
                            HighResThumbnailLoader.this.mLoaderIdling = false;
                        }
                        catch (InterruptedException interruptedException) {}
                    } else {
                        next = (Task)HighResThumbnailLoader.this.mLoadQueue.poll();
                        if (next != null) {
                            HighResThumbnailLoader.this.mLoadingTasks.add((Object)next);
                        }
                    }
                }
                if (next == null) continue;
                this.loadTask(next);
            }
        }

        private void loadTask(Task t) {
            ThumbnailData thumbnail = HighResThumbnailLoader.this.mActivityManager.getTaskThumbnail(t.key.id, false);
            HighResThumbnailLoader.this.mMainThreadHandler.post(() -> {
                ArrayDeque arrayDeque = HighResThumbnailLoader.this.mLoadQueue;
                synchronized (arrayDeque) {
                    HighResThumbnailLoader.this.mLoadingTasks.remove((Object)t);
                }
                if (HighResThumbnailLoader.this.mVisibleTasks.contains(t)) {
                    t.notifyTaskDataLoaded(thumbnail, t.icon);
                }
            });
        }
    };

    public HighResThumbnailLoader(ActivityManagerWrapper activityManager, Looper looper, boolean isLowRamDevice) {
        this.mActivityManager = activityManager;
        this.mMainThreadHandler = new Handler(looper);
        this.mLoadThread = new Thread(this.mLoader, "Recents-HighResThumbnailLoader");
        this.mLoadThread.start();
        this.mIsLowRamDevice = isLowRamDevice;
    }

    public void setVisible(boolean visible) {
        if (this.mIsLowRamDevice) {
            return;
        }
        this.mVisible = visible;
        this.updateLoading();
    }

    public void setFlingingFast(boolean flingingFast) {
        if (this.mFlingingFast == flingingFast || this.mIsLowRamDevice) {
            return;
        }
        this.mFlingingFast = flingingFast;
        this.updateLoading();
    }

    public void setTaskLoadQueueIdle(boolean idle) {
        if (this.mIsLowRamDevice) {
            return;
        }
        this.mTaskLoadQueueIdle = idle;
        this.updateLoading();
    }

    @VisibleForTesting
    boolean isLoading() {
        return this.mLoading;
    }

    private void updateLoading() {
        this.setLoading(this.mVisible && !this.mFlingingFast && this.mTaskLoadQueueIdle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setLoading(boolean loading) {
        if (loading == this.mLoading) {
            return;
        }
        ArrayDeque<Task> arrayDeque = this.mLoadQueue;
        synchronized (arrayDeque) {
            this.mLoading = loading;
            if (!loading) {
                this.stopLoading();
            } else {
                this.startLoading();
            }
        }
    }

    @GuardedBy(value={"mLoadQueue"})
    private void startLoading() {
        for (int i = this.mVisibleTasks.size() - 1; i >= 0; --i) {
            Task t = this.mVisibleTasks.get(i);
            if (t.thumbnail != null && !t.thumbnail.reducedResolution || this.mLoadQueue.contains(t) || this.mLoadingTasks.contains((Object)t)) continue;
            this.mLoadQueue.add(t);
        }
        this.mLoadQueue.notifyAll();
    }

    @GuardedBy(value={"mLoadQueue"})
    private void stopLoading() {
        this.mLoadQueue.clear();
        this.mLoadQueue.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTaskVisible(Task t) {
        t.addCallback(this);
        this.mVisibleTasks.add(t);
        if ((t.thumbnail == null || t.thumbnail.reducedResolution) && this.mLoading) {
            ArrayDeque<Task> arrayDeque = this.mLoadQueue;
            synchronized (arrayDeque) {
                this.mLoadQueue.add(t);
                this.mLoadQueue.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTaskInvisible(Task t) {
        t.removeCallback(this);
        this.mVisibleTasks.remove(t);
        ArrayDeque<Task> arrayDeque = this.mLoadQueue;
        synchronized (arrayDeque) {
            this.mLoadQueue.remove(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void waitForLoaderIdle() {
        while (true) {
            ArrayDeque<Task> arrayDeque = this.mLoadQueue;
            synchronized (arrayDeque) {
                if (this.mLoadQueue.isEmpty() && this.mLoaderIdling) {
                    return;
                }
            }
            SystemClock.sleep((long)100L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTaskDataLoaded(Task task, ThumbnailData thumbnailData) {
        if (thumbnailData != null && !thumbnailData.reducedResolution) {
            ArrayDeque<Task> arrayDeque = this.mLoadQueue;
            synchronized (arrayDeque) {
                this.mLoadQueue.remove(task);
            }
        }
    }

    @Override
    public void onTaskDataUnloaded() {
    }

    @Override
    public void onTaskWindowingModeChanged() {
    }
}

