/*
 * Decompiled with CFR 0.152.
 */
package com.android.systemui.shared.system;

import android.app.ActivityManager;
import android.app.ActivityOptions;
import android.app.AppGlobals;
import android.app.Application;
import android.app.IAssistDataReceiver;
import android.content.Context;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageItemInfo;
import android.content.pm.PackageManager;
import android.content.pm.UserInfo;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Handler;
import android.os.RemoteException;
import android.os.UserHandle;
import android.util.IconDrawableFactory;
import android.util.Log;
import com.android.systemui.shared.recents.model.Task;
import com.android.systemui.shared.recents.model.ThumbnailData;
import com.android.systemui.shared.system.AssistDataReceiverCompat;
import com.android.systemui.shared.system.BackgroundExecutor;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class ActivityManagerWrapper {
    private static final String TAG = "ActivityManagerWrapper";
    private static final ActivityManagerWrapper sInstance = new ActivityManagerWrapper();
    private final PackageManager mPackageManager;
    private final IconDrawableFactory mDrawableFactory;
    private final BackgroundExecutor mBackgroundExecutor;

    private ActivityManagerWrapper() {
        Application context = AppGlobals.getInitialApplication();
        this.mPackageManager = context.getPackageManager();
        this.mDrawableFactory = IconDrawableFactory.newInstance((Context)context);
        this.mBackgroundExecutor = BackgroundExecutor.get();
    }

    public static ActivityManagerWrapper getInstance() {
        return sInstance;
    }

    public int getCurrentUserId() {
        try {
            UserInfo ui = ActivityManager.getService().getCurrentUser();
            return ui != null ? ui.id : 0;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public ActivityManager.RunningTaskInfo getRunningTask() {
        try {
            List tasks = ActivityManager.getService().getFilteredTasks(1, 3, 2);
            if (tasks.isEmpty()) {
                return null;
            }
            return (ActivityManager.RunningTaskInfo)tasks.get(0);
        }
        catch (RemoteException e) {
            return null;
        }
    }

    public List<ActivityManager.RecentTaskInfo> getRecentTasks(int numTasks, int userId) {
        try {
            return ActivityManager.getService().getRecentTasks(numTasks, 2, userId).getList();
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)"Failed to get recent tasks", (Throwable)e);
            return new ArrayList<ActivityManager.RecentTaskInfo>();
        }
    }

    public ThumbnailData getTaskThumbnail(int taskId, boolean reducedResolution) {
        ActivityManager.TaskSnapshot snapshot = null;
        try {
            snapshot = ActivityManager.getService().getTaskSnapshot(taskId, reducedResolution);
        }
        catch (RemoteException e) {
            Log.w((String)TAG, (String)"Failed to retrieve task snapshot", (Throwable)e);
        }
        if (snapshot != null) {
            return new ThumbnailData(snapshot);
        }
        return new ThumbnailData();
    }

    public Drawable getBadgedTaskDescriptionIcon(Context context, ActivityManager.TaskDescription taskDescription, int userId, Resources res) {
        Bitmap tdIcon = taskDescription.getInMemoryIcon();
        BitmapDrawable dIcon = null;
        if (tdIcon != null) {
            dIcon = new BitmapDrawable(res, tdIcon);
        } else if (taskDescription.getIconResource() != 0) {
            try {
                dIcon = context.getDrawable(taskDescription.getIconResource());
            }
            catch (Resources.NotFoundException e) {
                Log.e((String)TAG, (String)"Could not find icon drawable from resource", (Throwable)e);
            }
        } else {
            tdIcon = ActivityManager.TaskDescription.loadTaskDescriptionIcon((String)taskDescription.getIconFilename(), (int)userId);
            if (tdIcon != null) {
                dIcon = new BitmapDrawable(res, tdIcon);
            }
        }
        if (dIcon != null) {
            return this.getBadgedIcon((Drawable)dIcon, userId);
        }
        return null;
    }

    private Drawable getBadgedIcon(Drawable icon, int userId) {
        if (userId != UserHandle.myUserId()) {
            icon = this.mPackageManager.getUserBadgedIcon(icon, new UserHandle(userId));
        }
        return icon;
    }

    public Drawable getBadgedActivityIcon(ActivityInfo info, int userId) {
        return this.mDrawableFactory.getBadgedIcon((PackageItemInfo)info, info.applicationInfo, userId);
    }

    public Drawable getBadgedApplicationIcon(ApplicationInfo appInfo, int userId) {
        return this.mDrawableFactory.getBadgedIcon(appInfo, userId);
    }

    public String getBadgedActivityLabel(ActivityInfo info, int userId) {
        return this.getBadgedLabel(info.loadLabel(this.mPackageManager).toString(), userId);
    }

    public String getBadgedApplicationLabel(ApplicationInfo appInfo, int userId) {
        return this.getBadgedLabel(appInfo.loadLabel(this.mPackageManager).toString(), userId);
    }

    public String getBadgedContentDescription(ActivityInfo info, int userId, ActivityManager.TaskDescription td) {
        String activityLabel = td != null && td.getLabel() != null ? td.getLabel() : info.loadLabel(this.mPackageManager).toString();
        String applicationLabel = info.applicationInfo.loadLabel(this.mPackageManager).toString();
        String badgedApplicationLabel = this.getBadgedLabel(applicationLabel, userId);
        return applicationLabel.equals(activityLabel) ? badgedApplicationLabel : badgedApplicationLabel + " " + activityLabel;
    }

    private String getBadgedLabel(String label, int userId) {
        if (userId != UserHandle.myUserId()) {
            label = this.mPackageManager.getUserBadgedLabel((CharSequence)label, new UserHandle(userId)).toString();
        }
        return label;
    }

    public void startRecentsActivity(final AssistDataReceiverCompat assistDataReceiver, Bundle options, ActivityOptions opts, int userId, final Consumer<Boolean> resultCallback, Handler resultCallbackHandler) {
        block4: {
            Bundle activityOptions = opts != null ? opts.toBundle() : null;
            try {
                IAssistDataReceiver.Stub receiver = null;
                if (assistDataReceiver != null) {
                    receiver = new IAssistDataReceiver.Stub(){

                        public void onHandleAssistData(Bundle resultData) {
                            assistDataReceiver.onHandleAssistData(resultData);
                        }

                        public void onHandleAssistScreenshot(Bitmap screenshot) {
                            assistDataReceiver.onHandleAssistScreenshot(screenshot);
                        }
                    };
                }
                ActivityManager.getService().startRecentsActivity((IAssistDataReceiver)receiver, options, activityOptions, userId);
                if (resultCallback != null) {
                    resultCallbackHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            resultCallback.accept(true);
                        }
                    });
                }
            }
            catch (Exception e) {
                if (resultCallback == null) break block4;
                resultCallbackHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        resultCallback.accept(false);
                    }
                });
            }
        }
    }

    public void startActivityFromRecentsAsync(Task.TaskKey taskKey, ActivityOptions options, Consumer<Boolean> resultCallback, Handler resultCallbackHandler) {
        this.startActivityFromRecentsAsync(taskKey, options, 0, 0, resultCallback, resultCallbackHandler);
    }

    public void startActivityFromRecentsAsync(final Task.TaskKey taskKey, ActivityOptions options, int windowingMode, int activityType, final Consumer<Boolean> resultCallback, final Handler resultCallbackHandler) {
        if (taskKey.windowingMode == 3) {
            if (options == null) {
                options = ActivityOptions.makeBasic();
            }
            options.setLaunchWindowingMode(4);
        } else if (windowingMode != 0 || activityType != 0) {
            if (options == null) {
                options = ActivityOptions.makeBasic();
            }
            options.setLaunchWindowingMode(windowingMode);
            options.setLaunchActivityType(activityType);
        }
        final ActivityOptions finalOptions = options;
        this.mBackgroundExecutor.submit(new Runnable(){

            @Override
            public void run() {
                block3: {
                    try {
                        ActivityManager.getService().startActivityFromRecents(taskKey.id, finalOptions == null ? null : finalOptions.toBundle());
                        if (resultCallback != null) {
                            resultCallbackHandler.post(new Runnable(){

                                @Override
                                public void run() {
                                    resultCallback.accept(true);
                                }
                            });
                        }
                    }
                    catch (Exception e) {
                        if (resultCallback == null) break block3;
                        resultCallbackHandler.post(new Runnable(){

                            @Override
                            public void run() {
                                resultCallback.accept(false);
                            }
                        });
                    }
                }
            }
        });
    }

    public void closeSystemWindows(final String reason) {
        this.mBackgroundExecutor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    ActivityManager.getService().closeSystemDialogs(reason);
                }
                catch (RemoteException e) {
                    Log.w((String)ActivityManagerWrapper.TAG, (String)"Failed to close system windows", (Throwable)e);
                }
            }
        });
    }

    public void removeTask(final int taskId) {
        this.mBackgroundExecutor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    ActivityManager.getService().removeTask(taskId);
                }
                catch (RemoteException e) {
                    Log.w((String)ActivityManagerWrapper.TAG, (String)("Failed to remove task=" + taskId), (Throwable)e);
                }
            }
        });
    }

    public void cancelWindowTransition(int taskId) {
        try {
            ActivityManager.getService().cancelTaskWindowTransition(taskId);
        }
        catch (RemoteException e) {
            Log.w((String)TAG, (String)("Failed to cancel window transition for task=" + taskId), (Throwable)e);
        }
    }

    public void cancelThumbnailTransition(int taskId) {
        try {
            ActivityManager.getService().cancelTaskThumbnailTransition(taskId);
        }
        catch (RemoteException e) {
            Log.w((String)TAG, (String)("Failed to cancel window transition for task=" + taskId), (Throwable)e);
        }
    }
}

