/*
 * Decompiled with CFR 0.152.
 */
package com.android.systemui.shared.system;

import android.app.ActivityManager;
import android.app.IActivityManager;
import android.app.ITaskStackListener;
import android.app.TaskStackListener;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.Trace;
import android.util.Log;
import com.android.systemui.shared.recents.model.ThumbnailData;
import com.android.systemui.shared.system.TaskStackChangeListener;
import java.util.ArrayList;
import java.util.List;

public class TaskStackChangeListeners
extends TaskStackListener {
    private static final String TAG = TaskStackChangeListeners.class.getSimpleName();
    private final List<TaskStackChangeListener> mTaskStackListeners = new ArrayList<TaskStackChangeListener>();
    private final List<TaskStackChangeListener> mTmpListeners = new ArrayList<TaskStackChangeListener>();
    private final Handler mHandler;
    private boolean mRegistered;

    public TaskStackChangeListeners(Looper looper) {
        this.mHandler = new H(looper);
    }

    public void addListener(IActivityManager am, TaskStackChangeListener listener) {
        this.mTaskStackListeners.add(listener);
        if (!this.mRegistered) {
            try {
                am.registerTaskStackListener((ITaskStackListener)this);
                this.mRegistered = true;
            }
            catch (Exception e) {
                Log.w((String)TAG, (String)"Failed to call registerTaskStackListener", (Throwable)e);
            }
        }
    }

    public void removeListener(TaskStackChangeListener listener) {
        this.mTaskStackListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTaskStackChanged() throws RemoteException {
        List<TaskStackChangeListener> list = this.mTaskStackListeners;
        synchronized (list) {
            this.mTmpListeners.clear();
            this.mTmpListeners.addAll(this.mTaskStackListeners);
        }
        for (int i = this.mTmpListeners.size() - 1; i >= 0; --i) {
            this.mTmpListeners.get(i).onTaskStackChangedBackground();
        }
        this.mHandler.removeMessages(1);
        this.mHandler.sendEmptyMessage(1);
    }

    public void onActivityPinned(String packageName, int userId, int taskId, int stackId) throws RemoteException {
        this.mHandler.removeMessages(3);
        this.mHandler.obtainMessage(3, (Object)new PinnedActivityInfo(packageName, userId, taskId, stackId)).sendToTarget();
    }

    public void onActivityUnpinned() throws RemoteException {
        this.mHandler.removeMessages(10);
        this.mHandler.sendEmptyMessage(10);
    }

    public void onPinnedActivityRestartAttempt(boolean clearedTask) throws RemoteException {
        this.mHandler.removeMessages(4);
        this.mHandler.obtainMessage(4, clearedTask ? 1 : 0, 0).sendToTarget();
    }

    public void onPinnedStackAnimationStarted() throws RemoteException {
        this.mHandler.removeMessages(9);
        this.mHandler.sendEmptyMessage(9);
    }

    public void onPinnedStackAnimationEnded() throws RemoteException {
        this.mHandler.removeMessages(5);
        this.mHandler.sendEmptyMessage(5);
    }

    public void onActivityForcedResizable(String packageName, int taskId, int reason) throws RemoteException {
        this.mHandler.obtainMessage(6, taskId, reason, (Object)packageName).sendToTarget();
    }

    public void onActivityDismissingDockedStack() throws RemoteException {
        this.mHandler.sendEmptyMessage(7);
    }

    public void onActivityLaunchOnSecondaryDisplayFailed() throws RemoteException {
        this.mHandler.sendEmptyMessage(11);
    }

    public void onTaskProfileLocked(int taskId, int userId) throws RemoteException {
        this.mHandler.obtainMessage(8, taskId, userId).sendToTarget();
    }

    public void onTaskSnapshotChanged(int taskId, ActivityManager.TaskSnapshot snapshot) throws RemoteException {
        this.mHandler.obtainMessage(2, taskId, 0, (Object)snapshot).sendToTarget();
    }

    private static class PinnedActivityInfo {
        final String mPackageName;
        final int mUserId;
        final int mTaskId;
        final int mStackId;

        PinnedActivityInfo(String packageName, int userId, int taskId, int stackId) {
            this.mPackageName = packageName;
            this.mUserId = userId;
            this.mTaskId = taskId;
            this.mStackId = stackId;
        }
    }

    private final class H
    extends Handler {
        private static final int ON_TASK_STACK_CHANGED = 1;
        private static final int ON_TASK_SNAPSHOT_CHANGED = 2;
        private static final int ON_ACTIVITY_PINNED = 3;
        private static final int ON_PINNED_ACTIVITY_RESTART_ATTEMPT = 4;
        private static final int ON_PINNED_STACK_ANIMATION_ENDED = 5;
        private static final int ON_ACTIVITY_FORCED_RESIZABLE = 6;
        private static final int ON_ACTIVITY_DISMISSING_DOCKED_STACK = 7;
        private static final int ON_TASK_PROFILE_LOCKED = 8;
        private static final int ON_PINNED_STACK_ANIMATION_STARTED = 9;
        private static final int ON_ACTIVITY_UNPINNED = 10;
        private static final int ON_ACTIVITY_LAUNCH_ON_SECONDARY_DISPLAY_FAILED = 11;

        public H(Looper looper) {
            super(looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message msg) {
            List list = TaskStackChangeListeners.this.mTaskStackListeners;
            synchronized (list) {
                switch (msg.what) {
                    case 1: {
                        Trace.beginSection((String)"onTaskStackChanged");
                        for (int i = TaskStackChangeListeners.this.mTaskStackListeners.size() - 1; i >= 0; --i) {
                            ((TaskStackChangeListener)TaskStackChangeListeners.this.mTaskStackListeners.get(i)).onTaskStackChanged();
                        }
                        Trace.endSection();
                        break;
                    }
                    case 2: {
                        Trace.beginSection((String)"onTaskSnapshotChanged");
                        for (int i = TaskStackChangeListeners.this.mTaskStackListeners.size() - 1; i >= 0; --i) {
                            ((TaskStackChangeListener)TaskStackChangeListeners.this.mTaskStackListeners.get(i)).onTaskSnapshotChanged(msg.arg1, new ThumbnailData((ActivityManager.TaskSnapshot)msg.obj));
                        }
                        Trace.endSection();
                        break;
                    }
                    case 3: {
                        PinnedActivityInfo info = (PinnedActivityInfo)msg.obj;
                        for (int i = TaskStackChangeListeners.this.mTaskStackListeners.size() - 1; i >= 0; --i) {
                            ((TaskStackChangeListener)TaskStackChangeListeners.this.mTaskStackListeners.get(i)).onActivityPinned(info.mPackageName, info.mUserId, info.mTaskId, info.mStackId);
                        }
                        break;
                    }
                    case 10: {
                        for (int i = TaskStackChangeListeners.this.mTaskStackListeners.size() - 1; i >= 0; --i) {
                            ((TaskStackChangeListener)TaskStackChangeListeners.this.mTaskStackListeners.get(i)).onActivityUnpinned();
                        }
                        break;
                    }
                    case 4: {
                        for (int i = TaskStackChangeListeners.this.mTaskStackListeners.size() - 1; i >= 0; --i) {
                            ((TaskStackChangeListener)TaskStackChangeListeners.this.mTaskStackListeners.get(i)).onPinnedActivityRestartAttempt(msg.arg1 != 0);
                        }
                        break;
                    }
                    case 9: {
                        for (int i = TaskStackChangeListeners.this.mTaskStackListeners.size() - 1; i >= 0; --i) {
                            ((TaskStackChangeListener)TaskStackChangeListeners.this.mTaskStackListeners.get(i)).onPinnedStackAnimationStarted();
                        }
                        break;
                    }
                    case 5: {
                        for (int i = TaskStackChangeListeners.this.mTaskStackListeners.size() - 1; i >= 0; --i) {
                            ((TaskStackChangeListener)TaskStackChangeListeners.this.mTaskStackListeners.get(i)).onPinnedStackAnimationEnded();
                        }
                        break;
                    }
                    case 6: {
                        for (int i = TaskStackChangeListeners.this.mTaskStackListeners.size() - 1; i >= 0; --i) {
                            ((TaskStackChangeListener)TaskStackChangeListeners.this.mTaskStackListeners.get(i)).onActivityForcedResizable((String)msg.obj, msg.arg1, msg.arg2);
                        }
                        break;
                    }
                    case 7: {
                        for (int i = TaskStackChangeListeners.this.mTaskStackListeners.size() - 1; i >= 0; --i) {
                            ((TaskStackChangeListener)TaskStackChangeListeners.this.mTaskStackListeners.get(i)).onActivityDismissingDockedStack();
                        }
                        break;
                    }
                    case 11: {
                        for (int i = TaskStackChangeListeners.this.mTaskStackListeners.size() - 1; i >= 0; --i) {
                            ((TaskStackChangeListener)TaskStackChangeListeners.this.mTaskStackListeners.get(i)).onActivityLaunchOnSecondaryDisplayFailed();
                        }
                        break;
                    }
                    case 8: {
                        for (int i = TaskStackChangeListeners.this.mTaskStackListeners.size() - 1; i >= 0; --i) {
                            ((TaskStackChangeListener)TaskStackChangeListeners.this.mTaskStackListeners.get(i)).onTaskProfileLocked(msg.arg1, msg.arg2);
                        }
                        break;
                    }
                }
            }
        }
    }
}

