/*
 * Decompiled with CFR 0.152.
 */
package com.android.systemui.shared.system;

import android.os.RemoteException;
import android.util.Log;
import android.view.IRemoteAnimationFinishedCallback;
import android.view.IRemoteAnimationRunner;
import android.view.RemoteAnimationAdapter;
import android.view.RemoteAnimationTarget;
import com.android.systemui.shared.system.RemoteAnimationRunnerCompat;
import com.android.systemui.shared.system.RemoteAnimationTargetCompat;

public class RemoteAnimationAdapterCompat {
    private final RemoteAnimationAdapter mWrapped;

    public RemoteAnimationAdapterCompat(RemoteAnimationRunnerCompat runner, long duration, long statusBarTransitionDelay) {
        this.mWrapped = new RemoteAnimationAdapter((IRemoteAnimationRunner)RemoteAnimationAdapterCompat.wrapRemoteAnimationRunner(runner), duration, statusBarTransitionDelay);
    }

    RemoteAnimationAdapter getWrapped() {
        return this.mWrapped;
    }

    private static IRemoteAnimationRunner.Stub wrapRemoteAnimationRunner(final RemoteAnimationRunnerCompat remoteAnimationAdapter) {
        return new IRemoteAnimationRunner.Stub(){

            public void onAnimationStart(RemoteAnimationTarget[] apps, final IRemoteAnimationFinishedCallback finishedCallback) {
                RemoteAnimationTargetCompat[] appsCompat = RemoteAnimationTargetCompat.wrap(apps);
                Runnable animationFinishedCallback = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            finishedCallback.onAnimationFinished();
                        }
                        catch (RemoteException e) {
                            Log.e((String)"ActivityOptionsCompat", (String)"Failed to call app controlled animation finished callback", (Throwable)e);
                        }
                    }
                };
                remoteAnimationAdapter.onAnimationStart(appsCompat, animationFinishedCallback);
            }

            public void onAnimationCancelled() {
                remoteAnimationAdapter.onAnimationCancelled();
            }
        };
    }
}

