/*
 * Decompiled with CFR 0.152.
 */
package com.android.systemui.shared.recents;

import android.graphics.Region;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.view.MotionEvent;
import com.android.systemui.shared.recents.ISystemUiProxy;

public interface IOverviewProxy
extends IInterface {
    public void onActiveNavBarRegionChanges(Region var1) throws RemoteException;

    public void onInitialize(Bundle var1) throws RemoteException;

    public void onBind(ISystemUiProxy var1) throws RemoteException;

    public void onPreMotionEvent(int var1) throws RemoteException;

    public void onMotionEvent(MotionEvent var1) throws RemoteException;

    public void onQuickScrubStart() throws RemoteException;

    public void onQuickScrubEnd() throws RemoteException;

    public void onQuickScrubProgress(float var1) throws RemoteException;

    public void onOverviewToggle() throws RemoteException;

    public void onOverviewShown(boolean var1) throws RemoteException;

    public void onOverviewHidden(boolean var1, boolean var2) throws RemoteException;

    public void onQuickStep(MotionEvent var1) throws RemoteException;

    public void onTip(int var1, int var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IOverviewProxy {
        private static final String DESCRIPTOR = "com.android.systemui.shared.recents.IOverviewProxy";
        static final int TRANSACTION_onActiveNavBarRegionChanges = 12;
        static final int TRANSACTION_onInitialize = 13;
        static final int TRANSACTION_onBind = 1;
        static final int TRANSACTION_onPreMotionEvent = 2;
        static final int TRANSACTION_onMotionEvent = 3;
        static final int TRANSACTION_onQuickScrubStart = 4;
        static final int TRANSACTION_onQuickScrubEnd = 5;
        static final int TRANSACTION_onQuickScrubProgress = 6;
        static final int TRANSACTION_onOverviewToggle = 7;
        static final int TRANSACTION_onOverviewShown = 8;
        static final int TRANSACTION_onOverviewHidden = 9;
        static final int TRANSACTION_onQuickStep = 10;
        static final int TRANSACTION_onTip = 11;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IOverviewProxy asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IOverviewProxy) {
                return (IOverviewProxy)iin;
            }
            return new Proxy(obj);
        }

        public IBinder asBinder() {
            return this;
        }

        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
                case 12: {
                    data.enforceInterface(descriptor);
                    Region _arg0 = 0 != data.readInt() ? (Region)Region.CREATOR.createFromParcel(data) : null;
                    this.onActiveNavBarRegionChanges(_arg0);
                    return true;
                }
                case 13: {
                    data.enforceInterface(descriptor);
                    Bundle _arg0 = 0 != data.readInt() ? (Bundle)Bundle.CREATOR.createFromParcel(data) : null;
                    this.onInitialize(_arg0);
                    return true;
                }
                case 1: {
                    data.enforceInterface(descriptor);
                    ISystemUiProxy _arg0 = ISystemUiProxy.Stub.asInterface(data.readStrongBinder());
                    this.onBind(_arg0);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.onPreMotionEvent(_arg0);
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    MotionEvent _arg0 = 0 != data.readInt() ? (MotionEvent)MotionEvent.CREATOR.createFromParcel(data) : null;
                    this.onMotionEvent(_arg0);
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    this.onQuickScrubStart();
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    this.onQuickScrubEnd();
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    float _arg0 = data.readFloat();
                    this.onQuickScrubProgress(_arg0);
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    this.onOverviewToggle();
                    return true;
                }
                case 8: {
                    data.enforceInterface(descriptor);
                    boolean _arg0 = 0 != data.readInt();
                    this.onOverviewShown(_arg0);
                    return true;
                }
                case 9: {
                    data.enforceInterface(descriptor);
                    boolean _arg0 = 0 != data.readInt();
                    boolean _arg1 = 0 != data.readInt();
                    this.onOverviewHidden(_arg0, _arg1);
                    return true;
                }
                case 10: {
                    data.enforceInterface(descriptor);
                    MotionEvent _arg0 = 0 != data.readInt() ? (MotionEvent)MotionEvent.CREATOR.createFromParcel(data) : null;
                    this.onQuickStep(_arg0);
                    return true;
                }
                case 11: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    this.onTip(_arg0, _arg1);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IOverviewProxy impl) {
            if (Proxy.sDefaultImpl == null && impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IOverviewProxy getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IOverviewProxy {
            private IBinder mRemote;
            public static IOverviewProxy sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onActiveNavBarRegionChanges(Region activeRegion) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (activeRegion != null) {
                        _data.writeInt(1);
                        activeRegion.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(12, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onActiveNavBarRegionChanges(activeRegion);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onInitialize(Bundle params) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (params != null) {
                        _data.writeInt(1);
                        params.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(13, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onInitialize(params);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onBind(ISystemUiProxy sysUiProxy) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(sysUiProxy != null ? sysUiProxy.asBinder() : null);
                    boolean _status = this.mRemote.transact(1, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onBind(sysUiProxy);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPreMotionEvent(int downHitTarget) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(downHitTarget);
                    boolean _status = this.mRemote.transact(2, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onPreMotionEvent(downHitTarget);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onMotionEvent(MotionEvent event) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (event != null) {
                        _data.writeInt(1);
                        event.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(3, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onMotionEvent(event);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onQuickScrubStart() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(4, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onQuickScrubStart();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onQuickScrubEnd() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(5, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onQuickScrubEnd();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onQuickScrubProgress(float progress) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeFloat(progress);
                    boolean _status = this.mRemote.transact(6, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onQuickScrubProgress(progress);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onOverviewToggle() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(7, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onOverviewToggle();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onOverviewShown(boolean triggeredFromAltTab) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(triggeredFromAltTab ? 1 : 0);
                    boolean _status = this.mRemote.transact(8, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onOverviewShown(triggeredFromAltTab);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onOverviewHidden(boolean triggeredFromAltTab, boolean triggeredFromHomeKey) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(triggeredFromAltTab ? 1 : 0);
                    _data.writeInt(triggeredFromHomeKey ? 1 : 0);
                    boolean _status = this.mRemote.transact(9, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onOverviewHidden(triggeredFromAltTab, triggeredFromHomeKey);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onQuickStep(MotionEvent event) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (event != null) {
                        _data.writeInt(1);
                        event.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(10, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onQuickStep(event);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onTip(int actionType, int viewType) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(actionType);
                    _data.writeInt(viewType);
                    boolean _status = this.mRemote.transact(11, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onTip(actionType, viewType);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IOverviewProxy {
        @Override
        public void onActiveNavBarRegionChanges(Region activeRegion) throws RemoteException {
        }

        @Override
        public void onInitialize(Bundle params) throws RemoteException {
        }

        @Override
        public void onBind(ISystemUiProxy sysUiProxy) throws RemoteException {
        }

        @Override
        public void onPreMotionEvent(int downHitTarget) throws RemoteException {
        }

        @Override
        public void onMotionEvent(MotionEvent event) throws RemoteException {
        }

        @Override
        public void onQuickScrubStart() throws RemoteException {
        }

        @Override
        public void onQuickScrubEnd() throws RemoteException {
        }

        @Override
        public void onQuickScrubProgress(float progress) throws RemoteException {
        }

        @Override
        public void onOverviewToggle() throws RemoteException {
        }

        @Override
        public void onOverviewShown(boolean triggeredFromAltTab) throws RemoteException {
        }

        @Override
        public void onOverviewHidden(boolean triggeredFromAltTab, boolean triggeredFromHomeKey) throws RemoteException {
        }

        @Override
        public void onQuickStep(MotionEvent event) throws RemoteException {
        }

        @Override
        public void onTip(int actionType, int viewType) throws RemoteException {
        }

        public IBinder asBinder() {
            return null;
        }
    }
}

