/*
 * Decompiled with CFR 0.152.
 */
package com.android.systemui.shared.plugins;

import android.util.ArrayMap;
import com.android.systemui.plugins.annotations.Dependencies;
import com.android.systemui.plugins.annotations.DependsOn;
import com.android.systemui.plugins.annotations.ProvidesInterface;
import com.android.systemui.plugins.annotations.Requirements;
import com.android.systemui.plugins.annotations.Requires;
import java.util.function.BiConsumer;

public class VersionInfo {
    private final ArrayMap<Class<?>, Version> mVersions = new ArrayMap();
    private Class<?> mDefault;

    public boolean hasVersionInfo() {
        return !this.mVersions.isEmpty();
    }

    public int getDefaultVersion() {
        return ((Version)this.mVersions.get(this.mDefault)).mVersion;
    }

    public VersionInfo addClass(Class<?> cls) {
        if (this.mDefault == null) {
            this.mDefault = cls;
        }
        this.addClass(cls, false);
        return this;
    }

    private void addClass(Class<?> cls, boolean required) {
        Dependencies dependencies;
        DependsOn depends;
        Requirements requirements;
        Requires requires;
        if (this.mVersions.containsKey(cls)) {
            return;
        }
        ProvidesInterface provider = cls.getDeclaredAnnotation(ProvidesInterface.class);
        if (provider != null) {
            this.mVersions.put(cls, (Object)new Version(provider.version(), true));
        }
        if ((requires = cls.getDeclaredAnnotation(Requires.class)) != null) {
            this.mVersions.put(requires.target(), (Object)new Version(requires.version(), required));
        }
        if ((requirements = cls.getDeclaredAnnotation(Requirements.class)) != null) {
            for (Requires r : requirements.value()) {
                this.mVersions.put(r.target(), (Object)new Version(r.version(), required));
            }
        }
        if ((depends = cls.getDeclaredAnnotation(DependsOn.class)) != null) {
            this.addClass(depends.target(), true);
        }
        if ((dependencies = cls.getDeclaredAnnotation(Dependencies.class)) != null) {
            for (DependsOn d : dependencies.value()) {
                this.addClass(d.target(), true);
            }
        }
    }

    public void checkVersion(VersionInfo plugin) throws InvalidVersionException {
        final ArrayMap versions = new ArrayMap(this.mVersions);
        plugin.mVersions.forEach(new BiConsumer<Class<?>, Version>(){

            @Override
            public void accept(Class<?> aClass, Version version) {
                Version v = (Version)versions.remove(aClass);
                if (v == null) {
                    v = VersionInfo.this.createVersion(aClass);
                }
                if (v == null) {
                    throw new InvalidVersionException(aClass.getSimpleName() + " does not provide an interface", false);
                }
                if (v.mVersion != version.mVersion) {
                    throw new InvalidVersionException(aClass, v.mVersion < version.mVersion, v.mVersion, version.mVersion);
                }
            }
        });
        versions.forEach(new BiConsumer<Class<?>, Version>(){

            @Override
            public void accept(Class<?> aClass, Version version) {
                if (version.mRequired) {
                    throw new InvalidVersionException("Missing required dependency " + aClass.getSimpleName(), false);
                }
            }
        });
    }

    private Version createVersion(Class<?> cls) {
        ProvidesInterface provider = cls.getDeclaredAnnotation(ProvidesInterface.class);
        if (provider != null) {
            return new Version(provider.version(), false);
        }
        return null;
    }

    public <T> boolean hasClass(Class<T> cls) {
        return this.mVersions.containsKey(cls);
    }

    private static class Version {
        private final int mVersion;
        private final boolean mRequired;

        public Version(int version, boolean required) {
            this.mVersion = version;
            this.mRequired = required;
        }
    }

    public static class InvalidVersionException
    extends RuntimeException {
        private final boolean mTooNew;

        public InvalidVersionException(String str, boolean tooNew) {
            super(str);
            this.mTooNew = tooNew;
        }

        public InvalidVersionException(Class<?> cls, boolean tooNew, int expected, int actual) {
            super(cls.getSimpleName() + " expected version " + expected + " but had " + actual);
            this.mTooNew = tooNew;
        }

        public boolean isTooNew() {
            return this.mTooNew;
        }
    }
}

