/*
 * Decompiled with CFR 0.152.
 */
package com.android.systemui.shared.system;

import android.content.Context;
import android.os.RemoteException;
import android.util.Log;
import android.view.IRotationWatcher;
import android.view.WindowManagerGlobal;

public abstract class RotationWatcher {
    private static final String TAG = "RotationWatcher";
    private final Context mContext;
    private final IRotationWatcher mWatcher = new IRotationWatcher.Stub(){

        public void onRotationChanged(int rotation) {
            RotationWatcher.this.onRotationChanged(rotation);
        }
    };
    private boolean mIsWatching = false;

    public RotationWatcher(Context context) {
        this.mContext = context;
    }

    protected abstract void onRotationChanged(int var1);

    public void enable() {
        if (!this.mIsWatching) {
            try {
                WindowManagerGlobal.getWindowManagerService().watchRotation(this.mWatcher, this.mContext.getDisplayId());
                this.mIsWatching = true;
            }
            catch (RemoteException e) {
                Log.w((String)TAG, (String)"Failed to set rotation watcher", (Throwable)e);
            }
        }
    }

    public void disable() {
        if (this.mIsWatching) {
            try {
                WindowManagerGlobal.getWindowManagerService().removeRotationWatcher(this.mWatcher);
                this.mIsWatching = false;
            }
            catch (RemoteException e) {
                Log.w((String)TAG, (String)"Failed to remove rotation watcher", (Throwable)e);
            }
        }
    }
}

