/*
 * Decompiled with CFR 0.152.
 */
package com.android.systemui.shared.system;

import android.graphics.HardwareRenderer;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.view.Surface;
import android.view.SurfaceControl;
import android.view.View;
import android.view.ViewRootImpl;
import com.android.systemui.shared.system.SurfaceControlCompat;
import com.android.systemui.shared.system.TransactionCompat;

public class SyncRtSurfaceTransactionApplier {
    private final Surface mTargetSurface;
    private final ViewRootImpl mTargetViewRootImpl;
    private final float[] mTmpFloat9 = new float[9];

    public SyncRtSurfaceTransactionApplier(View targetView) {
        this.mTargetViewRootImpl = targetView != null ? targetView.getViewRootImpl() : null;
        this.mTargetSurface = this.mTargetViewRootImpl != null ? this.mTargetViewRootImpl.mSurface : null;
    }

    public void scheduleApply(final SurfaceParams ... params) {
        if (this.mTargetViewRootImpl == null) {
            return;
        }
        this.mTargetViewRootImpl.registerRtFrameCallback(new HardwareRenderer.FrameDrawingCallback(){

            public void onFrameDraw(long frame) {
                if (SyncRtSurfaceTransactionApplier.this.mTargetSurface == null || !SyncRtSurfaceTransactionApplier.this.mTargetSurface.isValid()) {
                    return;
                }
                SurfaceControl.Transaction t = new SurfaceControl.Transaction();
                for (int i = params.length - 1; i >= 0; --i) {
                    SurfaceParams surfaceParams = params[i];
                    SurfaceControl surface = surfaceParams.surface;
                    t.deferTransactionUntilSurface(surface, SyncRtSurfaceTransactionApplier.this.mTargetSurface, frame);
                    SyncRtSurfaceTransactionApplier.applyParams(t, surfaceParams, SyncRtSurfaceTransactionApplier.this.mTmpFloat9);
                }
                t.setEarlyWakeup();
                t.apply();
            }
        });
        this.mTargetViewRootImpl.getView().invalidate();
    }

    public static void applyParams(TransactionCompat t, SurfaceParams params) {
        SyncRtSurfaceTransactionApplier.applyParams(t.mTransaction, params, t.mTmpValues);
    }

    private static void applyParams(SurfaceControl.Transaction t, SurfaceParams params, float[] tmpFloat9) {
        t.setMatrix(params.surface, params.matrix, tmpFloat9);
        t.setWindowCrop(params.surface, params.windowCrop);
        t.setAlpha(params.surface, params.alpha);
        t.setLayer(params.surface, params.layer);
        t.setCornerRadius(params.surface, params.cornerRadius);
        t.show(params.surface);
    }

    public static class SurfaceParams {
        final SurfaceControl surface;
        final float alpha;
        final Matrix matrix;
        final Rect windowCrop;
        final int layer;
        final float cornerRadius;

        public SurfaceParams(SurfaceControlCompat surface, float alpha, Matrix matrix, Rect windowCrop, int layer, float cornerRadius) {
            this.surface = surface.mSurfaceControl;
            this.alpha = alpha;
            this.matrix = new Matrix(matrix);
            this.windowCrop = new Rect(windowCrop);
            this.layer = layer;
            this.cornerRadius = cornerRadius;
        }
    }
}

