/*
 * Decompiled with CFR 0.152.
 */
package com.android.systemui.shared.system;

import android.app.AppGlobals;
import android.content.ComponentName;
import android.content.pm.ActivityInfo;
import android.content.pm.IPackageManager;
import android.content.pm.ResolveInfo;
import android.os.RemoteException;
import java.util.ArrayList;

public class PackageManagerWrapper {
    private static final String TAG = "PackageManagerWrapper";
    private static final PackageManagerWrapper sInstance = new PackageManagerWrapper();
    private static final IPackageManager mIPackageManager = AppGlobals.getPackageManager();

    public static PackageManagerWrapper getInstance() {
        return sInstance;
    }

    public ActivityInfo getActivityInfo(ComponentName componentName, int userId) {
        try {
            return mIPackageManager.getActivityInfo(componentName, 128, userId);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean isDefaultHomeActivity(String packageName) {
        ComponentName home;
        ArrayList allHomeCandidates = new ArrayList();
        try {
            home = mIPackageManager.getHomeActivities(allHomeCandidates);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
        if (home != null && packageName.equals(home.getPackageName())) {
            return true;
        }
        int lastPriority = Integer.MIN_VALUE;
        ComponentName lastComponent = null;
        int size = allHomeCandidates.size();
        for (int i = 0; i < size; ++i) {
            ResolveInfo ri = (ResolveInfo)allHomeCandidates.get(i);
            if (ri.priority > lastPriority) {
                lastComponent = ri.activityInfo.getComponentName();
                lastPriority = ri.priority;
                continue;
            }
            if (ri.priority != lastPriority) continue;
            lastComponent = null;
        }
        return lastComponent != null && packageName.equals(lastComponent.getPackageName());
    }
}

