/*
 * Decompiled with CFR 0.152.
 */
package com.android.systemui.shared.recents.model;

import android.app.ActivityManager;
import android.graphics.Bitmap;
import android.graphics.ColorSpace;
import android.graphics.GraphicBuffer;
import android.graphics.Rect;
import android.hardware.HardwareBuffer;

public class ThumbnailData {
    public final Bitmap thumbnail;
    public int orientation;
    public Rect insets;
    public boolean reducedResolution;
    public boolean isRealSnapshot;
    public boolean isTranslucent;
    public int windowingMode;
    public int systemUiVisibility;
    public float scale;

    public ThumbnailData() {
        this.thumbnail = null;
        this.orientation = 0;
        this.insets = new Rect();
        this.reducedResolution = false;
        this.scale = 1.0f;
        this.isRealSnapshot = true;
        this.isTranslucent = false;
        this.windowingMode = 0;
        this.systemUiVisibility = 0;
    }

    public ThumbnailData(ActivityManager.TaskSnapshot snapshot) {
        this.thumbnail = Bitmap.wrapHardwareBuffer((HardwareBuffer)HardwareBuffer.createFromGraphicBuffer((GraphicBuffer)snapshot.getSnapshot()), (ColorSpace)snapshot.getColorSpace());
        this.insets = new Rect(snapshot.getContentInsets());
        this.orientation = snapshot.getOrientation();
        this.reducedResolution = snapshot.isReducedResolution();
        this.scale = snapshot.getScale();
        this.isRealSnapshot = snapshot.isRealSnapshot();
        this.isTranslucent = snapshot.isTranslucent();
        this.windowingMode = snapshot.getWindowingMode();
        this.systemUiVisibility = snapshot.getSystemUiVisibility();
    }
}

