/*
 * Decompiled with CFR 0.152.
 */
package com.android.systemui.shared.plugins;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Log;
import android.widget.Toast;
import com.android.internal.annotations.VisibleForTesting;
import com.android.systemui.plugins.Plugin;
import com.android.systemui.plugins.PluginListener;
import com.android.systemui.plugins.annotations.ProvidesInterface;
import com.android.systemui.shared.plugins.PluginEnabler;
import com.android.systemui.shared.plugins.PluginInitializer;
import com.android.systemui.shared.plugins.PluginInstanceManager;
import com.android.systemui.shared.plugins.PluginManager;
import com.android.systemui.shared.plugins.PluginPrefs;
import com.android.systemui.shared.plugins.VersionInfo;
import dalvik.system.PathClassLoader;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Map;

public class PluginManagerImpl
extends BroadcastReceiver
implements PluginManager {
    private static final String TAG = PluginManagerImpl.class.getSimpleName();
    static final String DISABLE_PLUGIN = "com.android.systemui.action.DISABLE_PLUGIN";
    private static PluginManager sInstance;
    private final ArrayMap<PluginListener<?>, PluginInstanceManager> mPluginMap = new ArrayMap();
    private final Map<String, ClassLoader> mClassLoaders = new ArrayMap();
    private final ArraySet<String> mOneShotPackages = new ArraySet();
    private final ArraySet<String> mWhitelistedPlugins = new ArraySet();
    private final Context mContext;
    private final PluginInstanceManagerFactory mFactory;
    private final boolean isDebuggable;
    private final PluginPrefs mPluginPrefs;
    private final PluginEnabler mPluginEnabler;
    private final PluginInitializer mPluginInitializer;
    private ClassLoaderFilter mParentClassLoader;
    private boolean mListening;
    private boolean mHasOneShot;
    private Looper mLooper;

    public PluginManagerImpl(Context context, PluginInitializer initializer) {
        this(context, new PluginInstanceManagerFactory(), Build.IS_DEBUGGABLE, Thread.getUncaughtExceptionPreHandler(), initializer);
    }

    @VisibleForTesting
    PluginManagerImpl(Context context, PluginInstanceManagerFactory factory, boolean debuggable, Thread.UncaughtExceptionHandler defaultHandler, final PluginInitializer initializer) {
        this.mContext = context;
        this.mFactory = factory;
        this.mLooper = initializer.getBgLooper();
        this.isDebuggable = debuggable;
        this.mWhitelistedPlugins.addAll(Arrays.asList(initializer.getWhitelistedPlugins(this.mContext)));
        this.mPluginPrefs = new PluginPrefs(this.mContext);
        this.mPluginEnabler = initializer.getPluginEnabler(this.mContext);
        this.mPluginInitializer = initializer;
        PluginExceptionHandler uncaughtExceptionHandler = new PluginExceptionHandler(defaultHandler);
        Thread.setUncaughtExceptionPreHandler((Thread.UncaughtExceptionHandler)uncaughtExceptionHandler);
        new Handler(this.mLooper).post(new Runnable(){

            @Override
            public void run() {
                initializer.onPluginManagerInit();
            }
        });
    }

    @Override
    public String[] getWhitelistedPlugins() {
        return (String[])this.mWhitelistedPlugins.toArray((Object[])new String[0]);
    }

    public PluginEnabler getPluginEnabler() {
        return this.mPluginEnabler;
    }

    @Override
    public <T extends Plugin> T getOneShotPlugin(Class<T> cls) {
        ProvidesInterface info = cls.getDeclaredAnnotation(ProvidesInterface.class);
        if (info == null) {
            throw new RuntimeException(cls + " doesn't provide an interface");
        }
        if (TextUtils.isEmpty((CharSequence)info.action())) {
            throw new RuntimeException(cls + " doesn't provide an action");
        }
        return this.getOneShotPlugin(info.action(), cls);
    }

    @Override
    public <T extends Plugin> T getOneShotPlugin(String action, Class<?> cls) {
        if (Looper.myLooper() != Looper.getMainLooper()) {
            throw new RuntimeException("Must be called from UI thread");
        }
        PluginListener dummy = null;
        PluginInstanceManager p = this.mFactory.createPluginInstanceManager(this.mContext, action, dummy, false, this.mLooper, cls, this);
        this.mPluginPrefs.addAction(action);
        PluginInstanceManager.PluginInfo info = p.getPlugin();
        if (info != null) {
            this.mOneShotPackages.add((Object)info.mPackage);
            this.mHasOneShot = true;
            this.startListening();
            return (T)((Plugin)info.mPlugin);
        }
        return null;
    }

    @Override
    public <T extends Plugin> void addPluginListener(PluginListener<T> listener, Class<?> cls) {
        this.addPluginListener(listener, cls, false);
    }

    @Override
    public <T extends Plugin> void addPluginListener(PluginListener<T> listener, Class<?> cls, boolean allowMultiple) {
        this.addPluginListener(PluginManager.Helper.getAction(cls), listener, cls, allowMultiple);
    }

    @Override
    public <T extends Plugin> void addPluginListener(String action, PluginListener<T> listener, Class<?> cls) {
        this.addPluginListener(action, listener, cls, false);
    }

    @Override
    public <T extends Plugin> void addPluginListener(String action, PluginListener<T> listener, Class cls, boolean allowMultiple) {
        this.mPluginPrefs.addAction(action);
        PluginInstanceManager p = this.mFactory.createPluginInstanceManager(this.mContext, action, listener, allowMultiple, this.mLooper, cls, this);
        p.loadAll();
        this.mPluginMap.put(listener, (Object)p);
        this.startListening();
    }

    @Override
    public void removePluginListener(PluginListener<?> listener) {
        if (!this.mPluginMap.containsKey(listener)) {
            return;
        }
        ((PluginInstanceManager)this.mPluginMap.remove(listener)).destroy();
        if (this.mPluginMap.size() == 0) {
            this.stopListening();
        }
    }

    private void startListening() {
        if (this.mListening) {
            return;
        }
        this.mListening = true;
        IntentFilter filter = new IntentFilter("android.intent.action.PACKAGE_ADDED");
        filter.addAction("android.intent.action.PACKAGE_CHANGED");
        filter.addAction("android.intent.action.PACKAGE_REMOVED");
        filter.addAction("com.android.systemui.action.PLUGIN_CHANGED");
        filter.addAction(DISABLE_PLUGIN);
        filter.addDataScheme("package");
        this.mContext.registerReceiver((BroadcastReceiver)this, filter);
        filter = new IntentFilter("android.intent.action.USER_UNLOCKED");
        this.mContext.registerReceiver((BroadcastReceiver)this, filter);
    }

    private void stopListening() {
        if (!this.mListening || this.mHasOneShot) {
            return;
        }
        this.mListening = false;
        this.mContext.unregisterReceiver((BroadcastReceiver)this);
    }

    public void onReceive(Context context, Intent intent) {
        if ("android.intent.action.USER_UNLOCKED".equals(intent.getAction())) {
            for (PluginInstanceManager manager : this.mPluginMap.values()) {
                manager.loadAll();
            }
        } else if (DISABLE_PLUGIN.equals(intent.getAction())) {
            Uri uri = intent.getData();
            ComponentName component = ComponentName.unflattenFromString((String)uri.toString().substring(10));
            if (this.mWhitelistedPlugins.contains((Object)component.getPackageName())) {
                return;
            }
            this.getPluginEnabler().setEnabled(component, false);
            ((NotificationManager)this.mContext.getSystemService(NotificationManager.class)).cancel(component.getClassName(), 6);
        } else {
            Uri data = intent.getData();
            String pkg = data.getEncodedSchemeSpecificPart();
            if (this.mOneShotPackages.contains((Object)pkg)) {
                int icon = this.mContext.getResources().getIdentifier("tuner", "drawable", this.mContext.getPackageName());
                int color = Resources.getSystem().getIdentifier("system_notification_accent_color", "color", "android");
                String label = pkg;
                try {
                    PackageManager pm = this.mContext.getPackageManager();
                    label = pm.getApplicationInfo(pkg, 0).loadLabel(pm).toString();
                }
                catch (PackageManager.NameNotFoundException pm) {
                    // empty catch block
                }
                Notification.Builder nb = new Notification.Builder(this.mContext, "ALR").setSmallIcon(icon).setWhen(0L).setShowWhen(false).setPriority(2).setVisibility(1).setColor(this.mContext.getColor(color)).setContentTitle((CharSequence)("Plugin \"" + label + "\" has updated")).setContentText((CharSequence)"Restart SysUI for changes to take effect.");
                Intent i = new Intent("com.android.systemui.action.RESTART").setData(Uri.parse((String)("package://" + pkg)));
                PendingIntent pi = PendingIntent.getBroadcast((Context)this.mContext, (int)0, (Intent)i, (int)0);
                nb.addAction(new Notification.Action.Builder(null, (CharSequence)"Restart SysUI", pi).build());
                ((NotificationManager)this.mContext.getSystemService(NotificationManager.class)).notifyAsUser(pkg, 6, nb.build(), UserHandle.ALL);
            }
            if (this.clearClassLoader(pkg)) {
                if (Build.IS_ENG) {
                    Toast.makeText((Context)this.mContext, (CharSequence)("Reloading " + pkg), (int)1).show();
                } else {
                    Log.v((String)TAG, (String)("Reloading " + pkg));
                }
            }
            if (!"android.intent.action.PACKAGE_REMOVED".equals(intent.getAction())) {
                for (PluginInstanceManager manager : this.mPluginMap.values()) {
                    manager.onPackageChange(pkg);
                }
            } else {
                for (PluginInstanceManager manager : this.mPluginMap.values()) {
                    manager.onPackageRemoved(pkg);
                }
            }
        }
    }

    public ClassLoader getClassLoader(String sourceDir, String pkg) {
        if (!this.isDebuggable && !this.mWhitelistedPlugins.contains((Object)pkg)) {
            Log.w((String)TAG, (String)("Cannot get class loader for non-whitelisted plugin. Src:" + sourceDir + ", pkg: " + pkg));
            return null;
        }
        if (this.mClassLoaders.containsKey(pkg)) {
            return this.mClassLoaders.get(pkg);
        }
        PathClassLoader classLoader = new PathClassLoader(sourceDir, this.getParentClassLoader());
        this.mClassLoaders.put(pkg, (ClassLoader)classLoader);
        return classLoader;
    }

    private boolean clearClassLoader(String pkg) {
        return this.mClassLoaders.remove(pkg) != null;
    }

    ClassLoader getParentClassLoader() {
        if (this.mParentClassLoader == null) {
            this.mParentClassLoader = new ClassLoaderFilter(this.getClass().getClassLoader(), "com.android.systemui.plugin");
        }
        return this.mParentClassLoader;
    }

    public Context getContext(ApplicationInfo info, String pkg) throws PackageManager.NameNotFoundException {
        ClassLoader classLoader = this.getClassLoader(info.sourceDir, pkg);
        return new PluginInstanceManager.PluginContextWrapper(this.mContext.createApplicationContext(info, 0), classLoader);
    }

    @Override
    public <T> boolean dependsOn(Plugin p, Class<T> cls) {
        for (int i = 0; i < this.mPluginMap.size(); ++i) {
            if (!((PluginInstanceManager)this.mPluginMap.valueAt(i)).dependsOn(p, cls)) continue;
            return true;
        }
        return false;
    }

    public void handleWtfs() {
        this.mPluginInitializer.handleWtfs();
    }

    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println(String.format("  plugin map (%d):", this.mPluginMap.size()));
        for (PluginListener listener : this.mPluginMap.keySet()) {
            pw.println(String.format("    %s -> %s", listener, this.mPluginMap.get((Object)listener)));
        }
    }

    public static class CrashWhilePluginActiveException
    extends RuntimeException {
        public CrashWhilePluginActiveException(Throwable throwable) {
            super(throwable);
        }
    }

    private class PluginExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private final Thread.UncaughtExceptionHandler mHandler;

        private PluginExceptionHandler(Thread.UncaughtExceptionHandler handler) {
            this.mHandler = handler;
        }

        @Override
        public void uncaughtException(Thread thread, Throwable throwable) {
            if (SystemProperties.getBoolean((String)"plugin.debugging", (boolean)false)) {
                this.mHandler.uncaughtException(thread, throwable);
                return;
            }
            boolean disabledAny = this.checkStack(throwable);
            if (!disabledAny) {
                for (PluginInstanceManager manager : PluginManagerImpl.this.mPluginMap.values()) {
                    disabledAny |= manager.disableAll();
                }
            }
            if (disabledAny) {
                throwable = new CrashWhilePluginActiveException(throwable);
            }
            this.mHandler.uncaughtException(thread, throwable);
        }

        private boolean checkStack(Throwable throwable) {
            if (throwable == null) {
                return false;
            }
            boolean disabledAny = false;
            for (StackTraceElement element : throwable.getStackTrace()) {
                for (PluginInstanceManager manager : PluginManagerImpl.this.mPluginMap.values()) {
                    disabledAny |= manager.checkAndDisable(element.getClassName());
                }
            }
            return disabledAny | this.checkStack(throwable.getCause());
        }
    }

    private static class ClassLoaderFilter
    extends ClassLoader {
        private final String mPackage;
        private final ClassLoader mBase;

        public ClassLoaderFilter(ClassLoader base, String pkg) {
            super(ClassLoader.getSystemClassLoader());
            this.mBase = base;
            this.mPackage = pkg;
        }

        @Override
        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            if (!name.startsWith(this.mPackage)) {
                super.loadClass(name, resolve);
            }
            return this.mBase.loadClass(name);
        }
    }

    @VisibleForTesting
    public static class PluginInstanceManagerFactory {
        public <T extends Plugin> PluginInstanceManager createPluginInstanceManager(Context context, String action, PluginListener<T> listener, boolean allowMultiple, Looper looper, Class<?> cls, PluginManagerImpl manager) {
            return new PluginInstanceManager<T>(context, action, listener, allowMultiple, looper, new VersionInfo().addClass(cls), manager);
        }
    }
}

