/*
 * Copyright (C) 2017 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.android.launcher3.allapps;

import android.graphics.Rect;
import android.view.KeyEvent;

import androidx.annotation.Nullable;

import com.android.launcher3.ExtendedEditText;

/**
 * Interface for controlling the Apps search UI.
 */
public interface SearchUiManager {

    /**
     * Initializes the search manager.
     */
    void initializeSearch(AllAppsContainerView containerView);

    /**
     * Notifies the search manager to close any active search session.
     */
    void resetSearch();

    /**
     * Called before dispatching a key event, in case the search manager wants to initialize
     * some UI beforehand.
     */
    default void preDispatchKeyEvent(KeyEvent keyEvent) { };

    /**
     * Returns the vertical shift for the all-apps view, so that it aligns with the hotseat.
     */
    float getScrollRangeDelta(Rect insets);

    /**
     * Called when activity is destroyed. Used to close search system services
     */
    default void destroySearch() { }

    /**
     * @return the edit text object
     */
    @Nullable
    ExtendedEditText getEditText();

    /**
     * sets highlight result's title
     */
    default void setFocusedResultTitle(@Nullable  CharSequence title) { }
}
