/*
 * Decompiled with CFR 0.152.
 */
package com.android.systemui.shared.recents;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.view.MotionEvent;
import com.android.systemui.shared.recents.ISystemUiProxy;

public interface IOverviewProxy
extends IInterface {
    public void onBind(ISystemUiProxy var1) throws RemoteException;

    public void onMotionEvent(MotionEvent var1) throws RemoteException;

    public void onQuickSwitch() throws RemoteException;

    public void onQuickScrubStart() throws RemoteException;

    public void onQuickScrubEnd() throws RemoteException;

    public void onQuickScrubProgress(float var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IOverviewProxy {
        private static final String DESCRIPTOR = "com.android.systemui.shared.recents.IOverviewProxy";
        static final int TRANSACTION_onBind = 1;
        static final int TRANSACTION_onMotionEvent = 2;
        static final int TRANSACTION_onQuickSwitch = 3;
        static final int TRANSACTION_onQuickScrubStart = 4;
        static final int TRANSACTION_onQuickScrubEnd = 5;
        static final int TRANSACTION_onQuickScrubProgress = 6;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IOverviewProxy asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IOverviewProxy) {
                return (IOverviewProxy)iin;
            }
            return new Proxy(obj);
        }

        public IBinder asBinder() {
            return this;
        }

        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
                case 1: {
                    data.enforceInterface(descriptor);
                    ISystemUiProxy _arg0 = ISystemUiProxy.Stub.asInterface(data.readStrongBinder());
                    this.onBind(_arg0);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    MotionEvent _arg0 = 0 != data.readInt() ? (MotionEvent)MotionEvent.CREATOR.createFromParcel(data) : null;
                    this.onMotionEvent(_arg0);
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    this.onQuickSwitch();
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    this.onQuickScrubStart();
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    this.onQuickScrubEnd();
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    float _arg0 = data.readFloat();
                    this.onQuickScrubProgress(_arg0);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        private static class Proxy
        implements IOverviewProxy {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            @Override
            public void onBind(ISystemUiProxy sysUiProxy) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(sysUiProxy != null ? sysUiProxy.asBinder() : null);
                    this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onMotionEvent(MotionEvent event) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (event != null) {
                        _data.writeInt(1);
                        event.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onQuickSwitch() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onQuickScrubStart() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onQuickScrubEnd() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onQuickScrubProgress(float progress) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeFloat(progress);
                    this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }
}

