/*
 * Decompiled with CFR 0.152.
 */
package com.android.systemui.shared.system;

import android.graphics.HardwareRenderer;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.view.Surface;
import android.view.View;
import android.view.ViewRootImpl;
import com.android.systemui.shared.system.SurfaceControlCompat;
import com.android.systemui.shared.system.TransactionCompat;
import java.util.function.Consumer;

public class SyncRtSurfaceTransactionApplierCompat {
    private final Surface mTargetSurface;
    private final ViewRootImpl mTargetViewRootImpl;

    public SyncRtSurfaceTransactionApplierCompat(View targetView) {
        this.mTargetViewRootImpl = targetView != null ? targetView.getViewRootImpl() : null;
        this.mTargetSurface = this.mTargetViewRootImpl != null ? this.mTargetViewRootImpl.mSurface : null;
    }

    public void scheduleApply(final SurfaceParams ... params) {
        if (this.mTargetViewRootImpl == null) {
            return;
        }
        this.mTargetViewRootImpl.registerRtFrameCallback(new HardwareRenderer.FrameDrawingCallback(){

            public void onFrameDraw(long frame) {
                if (SyncRtSurfaceTransactionApplierCompat.this.mTargetSurface == null || !SyncRtSurfaceTransactionApplierCompat.this.mTargetSurface.isValid()) {
                    return;
                }
                TransactionCompat t = new TransactionCompat();
                for (int i = params.length - 1; i >= 0; --i) {
                    SurfaceParams surfaceParams = params[i];
                    SurfaceControlCompat surface = surfaceParams.surface;
                    t.deferTransactionUntil(surface, SyncRtSurfaceTransactionApplierCompat.this.mTargetSurface, frame);
                    SyncRtSurfaceTransactionApplierCompat.applyParams(t, surfaceParams);
                }
                t.setEarlyWakeup();
                t.apply();
            }
        });
        this.mTargetViewRootImpl.getView().invalidate();
    }

    public static void applyParams(TransactionCompat t, SurfaceParams params) {
        t.setMatrix(params.surface, params.matrix);
        t.setWindowCrop(params.surface, params.windowCrop);
        t.setAlpha(params.surface, params.alpha);
        t.setLayer(params.surface, params.layer);
        t.setCornerRadius(params.surface, params.cornerRadius);
        t.show(params.surface);
    }

    public static void create(final View targetView, final Consumer<SyncRtSurfaceTransactionApplierCompat> callback) {
        if (targetView == null) {
            callback.accept(null);
        } else if (targetView.getViewRootImpl() != null) {
            callback.accept(new SyncRtSurfaceTransactionApplierCompat(targetView));
        } else {
            targetView.addOnAttachStateChangeListener(new View.OnAttachStateChangeListener(){

                public void onViewAttachedToWindow(View v) {
                    targetView.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
                    callback.accept(new SyncRtSurfaceTransactionApplierCompat(targetView));
                }

                public void onViewDetachedFromWindow(View v) {
                }
            });
        }
    }

    public static class SurfaceParams {
        public final SurfaceControlCompat surface;
        public final float alpha;
        final float cornerRadius;
        public final Matrix matrix;
        public final Rect windowCrop;
        public final int layer;

        public SurfaceParams(SurfaceControlCompat surface, float alpha, Matrix matrix, Rect windowCrop, int layer, float cornerRadius) {
            this.surface = surface;
            this.alpha = alpha;
            this.matrix = new Matrix(matrix);
            this.windowCrop = new Rect(windowCrop);
            this.layer = layer;
            this.cornerRadius = cornerRadius;
        }
    }
}

