/*
 * Decompiled with CFR 0.152.
 */
package com.android.systemui.shared.recents.model;

import android.content.Context;
import android.content.pm.ActivityInfo;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.Log;
import com.android.systemui.shared.recents.model.Task;
import com.android.systemui.shared.recents.model.TaskKeyLruCache;
import com.android.systemui.shared.recents.model.TaskResourceLoadQueue;
import com.android.systemui.shared.recents.model.ThumbnailData;
import com.android.systemui.shared.system.ActivityManagerWrapper;
import com.android.systemui.shared.system.PackageManagerWrapper;

class BackgroundTaskLoader
implements Runnable {
    static String TAG = "BackgroundTaskLoader";
    static boolean DEBUG = false;
    private Context mContext;
    private final HandlerThread mLoadThread;
    private final Handler mLoadThreadHandler;
    private final Handler mMainThreadHandler;
    private final TaskResourceLoadQueue mLoadQueue;
    private final TaskKeyLruCache<Drawable> mIconCache;
    private final BitmapDrawable mDefaultIcon;
    private boolean mStarted;
    private boolean mCancelled;
    private boolean mWaitingOnLoadQueue;
    private final OnIdleChangedListener mOnIdleChangedListener;

    public BackgroundTaskLoader(TaskResourceLoadQueue loadQueue, TaskKeyLruCache<Drawable> iconCache, BitmapDrawable defaultIcon, OnIdleChangedListener onIdleChangedListener) {
        this.mLoadQueue = loadQueue;
        this.mIconCache = iconCache;
        this.mDefaultIcon = defaultIcon;
        this.mMainThreadHandler = new Handler();
        this.mOnIdleChangedListener = onIdleChangedListener;
        this.mLoadThread = new HandlerThread("Recents-TaskResourceLoader", 10);
        this.mLoadThread.start();
        this.mLoadThreadHandler = new Handler(this.mLoadThread.getLooper());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void start(Context context) {
        this.mContext = context;
        this.mCancelled = false;
        if (!this.mStarted) {
            this.mStarted = true;
            this.mLoadThreadHandler.post((Runnable)this);
        } else {
            HandlerThread handlerThread = this.mLoadThread;
            synchronized (handlerThread) {
                this.mLoadThread.notifyAll();
            }
        }
    }

    void stop() {
        this.mCancelled = true;
        if (this.mWaitingOnLoadQueue) {
            this.mContext = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            Object object;
            if (this.mCancelled) {
                this.mContext = null;
                object = this.mLoadThread;
                synchronized (object) {
                    try {
                        this.mLoadThread.wait();
                    }
                    catch (InterruptedException ie) {
                        ie.printStackTrace();
                    }
                }
            }
            this.processLoadQueueItem();
            if (this.mCancelled || !this.mLoadQueue.isEmpty()) continue;
            object = this.mLoadQueue;
            synchronized (object) {
                try {
                    this.mWaitingOnLoadQueue = true;
                    this.mMainThreadHandler.post(() -> this.mOnIdleChangedListener.onIdleChanged(true));
                    this.mLoadQueue.wait();
                    this.mMainThreadHandler.post(() -> this.mOnIdleChangedListener.onIdleChanged(false));
                    this.mWaitingOnLoadQueue = false;
                }
                catch (InterruptedException ie) {
                    ie.printStackTrace();
                }
            }
        }
    }

    private void processLoadQueueItem() {
        Task t = this.mLoadQueue.nextTask();
        if (t != null) {
            Drawable cachedIcon = (Drawable)this.mIconCache.get(t.key);
            if (cachedIcon == null) {
                ActivityInfo info;
                cachedIcon = ActivityManagerWrapper.getInstance().getBadgedTaskDescriptionIcon(this.mContext, t.taskDescription, t.key.userId, this.mContext.getResources());
                if (cachedIcon == null && (info = PackageManagerWrapper.getInstance().getActivityInfo(t.key.getComponent(), t.key.userId)) != null) {
                    if (DEBUG) {
                        Log.d((String)TAG, (String)("Loading icon: " + t.key));
                    }
                    cachedIcon = ActivityManagerWrapper.getInstance().getBadgedActivityIcon(info, t.key.userId);
                }
                if (cachedIcon == null) {
                    cachedIcon = this.mDefaultIcon;
                }
                this.mIconCache.put(t.key, cachedIcon);
            }
            if (DEBUG) {
                Log.d((String)TAG, (String)("Loading thumbnail: " + t.key));
            }
            ThumbnailData thumbnailData = ActivityManagerWrapper.getInstance().getTaskThumbnail(t.key.id, true);
            if (!this.mCancelled) {
                Drawable finalIcon = cachedIcon;
                this.mMainThreadHandler.post(() -> t.notifyTaskDataLoaded(thumbnailData, finalIcon));
            }
        }
    }

    static interface OnIdleChangedListener {
        public void onIdleChanged(boolean var1);
    }
}

