/*
 * Decompiled with CFR 0.152.
 */
package com.android.systemui.shared.recents.model;

import android.util.Log;
import android.util.SparseArray;
import com.android.systemui.shared.recents.model.Task;

public abstract class TaskKeyCache<V> {
    protected static final String TAG = "TaskKeyCache";
    protected final SparseArray<Task.TaskKey> mKeys = new SparseArray();

    final synchronized V get(Task.TaskKey key) {
        return this.getCacheEntry(key.id);
    }

    final synchronized V getAndInvalidateIfModified(Task.TaskKey key) {
        Task.TaskKey lastKey = (Task.TaskKey)this.mKeys.get(key.id);
        if (lastKey != null && (lastKey.windowingMode != key.windowingMode || lastKey.lastActiveTime != key.lastActiveTime)) {
            this.remove(key);
            return null;
        }
        return this.getCacheEntry(key.id);
    }

    final synchronized void put(Task.TaskKey key, V value) {
        if (key == null || value == null) {
            Log.e((String)TAG, (String)("Unexpected null key or value: " + key + ", " + value));
            return;
        }
        this.mKeys.put(key.id, (Object)key);
        this.putCacheEntry(key.id, value);
    }

    final synchronized void remove(Task.TaskKey key) {
        this.removeCacheEntry(key.id);
        this.mKeys.remove(key.id);
    }

    final synchronized void evictAll() {
        this.evictAllCache();
        this.mKeys.clear();
    }

    protected abstract V getCacheEntry(int var1);

    protected abstract void putCacheEntry(int var1, V var2);

    protected abstract void removeCacheEntry(int var1);

    protected abstract void evictAllCache();
}

