/*
 * Decompiled with CFR 0.152.
 */
package com.android.systemui.shared.recents.model;

import android.content.ComponentName;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.SparseArray;
import com.android.systemui.shared.recents.model.FilteredTaskList;
import com.android.systemui.shared.recents.model.Task;
import com.android.systemui.shared.recents.model.TaskFilter;
import com.android.systemui.shared.recents.utilities.AnimationProps;
import com.android.systemui.shared.system.PackageManagerWrapper;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

@Deprecated
public class TaskStack {
    private static final String TAG = "TaskStack";
    private final ArrayList<Task> mRawTaskList = new ArrayList();
    private final FilteredTaskList mStackTaskList = new FilteredTaskList();
    private TaskStackCallbacks mCb;

    public TaskStack() {
        this.mStackTaskList.setFilter(new TaskFilter(){

            @Override
            public boolean acceptTask(SparseArray<Task> taskIdMap, Task t, int index) {
                return t.isStackTask;
            }
        });
    }

    public void setCallbacks(TaskStackCallbacks cb) {
        this.mCb = cb;
    }

    public void removeTask(Task t, AnimationProps animation, boolean fromDockGesture) {
        this.removeTask(t, animation, fromDockGesture, true);
    }

    public void removeTask(Task t, AnimationProps animation, boolean fromDockGesture, boolean dismissRecentsIfAllRemoved) {
        if (this.mStackTaskList.contains(t)) {
            this.mStackTaskList.remove(t);
            Task newFrontMostTask = this.getFrontMostTask();
            if (this.mCb != null) {
                this.mCb.onStackTaskRemoved(this, t, newFrontMostTask, animation, fromDockGesture, dismissRecentsIfAllRemoved);
            }
        }
        this.mRawTaskList.remove(t);
    }

    public void removeAllTasks(boolean notifyStackChanges) {
        ArrayList<Task> tasks = this.mStackTaskList.getTasks();
        for (int i = tasks.size() - 1; i >= 0; --i) {
            Task t = tasks.get(i);
            this.mStackTaskList.remove(t);
            this.mRawTaskList.remove(t);
        }
        if (this.mCb != null && notifyStackChanges) {
            this.mCb.onStackTasksRemoved(this);
        }
    }

    public void setTasks(TaskStack stack, boolean notifyStackChanges) {
        this.setTasks(stack.mRawTaskList, notifyStackChanges);
    }

    public void setTasks(List<Task> tasks, boolean notifyStackChanges) {
        int i;
        ArrayMap<Task.TaskKey, Task> currentTasksMap = this.createTaskKeyMapFromList(this.mRawTaskList);
        ArrayMap<Task.TaskKey, Task> newTasksMap = this.createTaskKeyMapFromList(tasks);
        ArrayList<Task> addedTasks = new ArrayList<Task>();
        ArrayList<Task> removedTasks = new ArrayList<Task>();
        ArrayList<Task> allTasks = new ArrayList<Task>();
        if (this.mCb == null) {
            notifyStackChanges = false;
        }
        int taskCount = this.mRawTaskList.size();
        for (i = taskCount - 1; i >= 0; --i) {
            Task task = this.mRawTaskList.get(i);
            if (newTasksMap.containsKey((Object)task.key) || !notifyStackChanges) continue;
            removedTasks.add(task);
        }
        taskCount = tasks.size();
        for (i = 0; i < taskCount; ++i) {
            Task newTask = tasks.get(i);
            Task currentTask = (Task)currentTasksMap.get((Object)newTask.key);
            if (currentTask == null && notifyStackChanges) {
                addedTasks.add(newTask);
            } else if (currentTask != null) {
                currentTask.copyFrom(newTask);
                newTask = currentTask;
            }
            allTasks.add(newTask);
        }
        for (i = allTasks.size() - 1; i >= 0; --i) {
            ((Task)allTasks.get((int)i)).temporarySortIndexInStack = i;
        }
        this.mStackTaskList.set(allTasks);
        this.mRawTaskList.clear();
        this.mRawTaskList.addAll(allTasks);
        int removedTaskCount = removedTasks.size();
        Task newFrontMostTask = this.getFrontMostTask();
        for (int i2 = 0; i2 < removedTaskCount; ++i2) {
            this.mCb.onStackTaskRemoved(this, (Task)removedTasks.get(i2), newFrontMostTask, AnimationProps.IMMEDIATE, false, true);
        }
        int addedTaskCount = addedTasks.size();
        for (int i3 = 0; i3 < addedTaskCount; ++i3) {
            this.mCb.onStackTaskAdded(this, (Task)addedTasks.get(i3));
        }
        if (notifyStackChanges) {
            this.mCb.onStackTasksUpdated(this);
        }
    }

    public Task getFrontMostTask() {
        ArrayList<Task> stackTasks = this.mStackTaskList.getTasks();
        if (stackTasks.isEmpty()) {
            return null;
        }
        return stackTasks.get(stackTasks.size() - 1);
    }

    public ArrayList<Task.TaskKey> getTaskKeys() {
        ArrayList<Task.TaskKey> taskKeys = new ArrayList<Task.TaskKey>();
        ArrayList<Task> tasks = this.computeAllTasksList();
        int taskCount = tasks.size();
        for (int i = 0; i < taskCount; ++i) {
            Task task = tasks.get(i);
            taskKeys.add(task.key);
        }
        return taskKeys;
    }

    public ArrayList<Task> getTasks() {
        return this.mStackTaskList.getTasks();
    }

    public ArrayList<Task> computeAllTasksList() {
        ArrayList<Task> tasks = new ArrayList<Task>();
        tasks.addAll(this.mStackTaskList.getTasks());
        return tasks;
    }

    public int getTaskCount() {
        return this.mStackTaskList.size();
    }

    public Task getLaunchTarget() {
        ArrayList<Task> tasks = this.mStackTaskList.getTasks();
        int taskCount = tasks.size();
        for (int i = 0; i < taskCount; ++i) {
            Task task = tasks.get(i);
            if (!task.isLaunchTarget) continue;
            return task;
        }
        return null;
    }

    public boolean isNextLaunchTargetPip(long lastPipTime) {
        Task launchTarget = this.getLaunchTarget();
        Task nextLaunchTarget = this.getNextLaunchTargetRaw();
        if (nextLaunchTarget != null && lastPipTime > 0L) {
            return lastPipTime > nextLaunchTarget.key.lastActiveTime;
        }
        return launchTarget != null && lastPipTime > 0L && this.getTaskCount() == 1;
    }

    public Task getNextLaunchTarget() {
        Task nextLaunchTarget = this.getNextLaunchTargetRaw();
        if (nextLaunchTarget != null) {
            return nextLaunchTarget;
        }
        return this.getTasks().get(this.getTaskCount() - 1);
    }

    private Task getNextLaunchTargetRaw() {
        int taskCount = this.getTaskCount();
        if (taskCount == 0) {
            return null;
        }
        int launchTaskIndex = this.indexOfTask(this.getLaunchTarget());
        if (launchTaskIndex != -1 && launchTaskIndex > 0) {
            return this.getTasks().get(launchTaskIndex - 1);
        }
        return null;
    }

    public int indexOfTask(Task t) {
        return this.mStackTaskList.indexOf(t);
    }

    public Task findTaskWithId(int taskId) {
        ArrayList<Task> tasks = this.computeAllTasksList();
        int taskCount = tasks.size();
        for (int i = 0; i < taskCount; ++i) {
            Task task = tasks.get(i);
            if (task.key.id != taskId) continue;
            return task;
        }
        return null;
    }

    public ArraySet<ComponentName> computeComponentsRemoved(String packageName, int userId) {
        ArraySet existingComponents = new ArraySet();
        ArraySet removedComponents = new ArraySet();
        ArrayList<Task.TaskKey> taskKeys = this.getTaskKeys();
        int taskKeyCount = taskKeys.size();
        for (int i = 0; i < taskKeyCount; ++i) {
            ComponentName cn;
            Task.TaskKey t = taskKeys.get(i);
            if (t.userId != userId || !(cn = t.getComponent()).getPackageName().equals(packageName) || existingComponents.contains((Object)cn)) continue;
            if (PackageManagerWrapper.getInstance().getActivityInfo(cn, userId) != null) {
                existingComponents.add((Object)cn);
                continue;
            }
            removedComponents.add((Object)cn);
        }
        return removedComponents;
    }

    public String toString() {
        String str = "Stack Tasks (" + this.mStackTaskList.size() + "):\n";
        ArrayList<Task> tasks = this.mStackTaskList.getTasks();
        int taskCount = tasks.size();
        for (int i = 0; i < taskCount; ++i) {
            str = str + "    " + tasks.get(i).toString() + "\n";
        }
        return str;
    }

    private ArrayMap<Task.TaskKey, Task> createTaskKeyMapFromList(List<Task> tasks) {
        ArrayMap map = new ArrayMap(tasks.size());
        int taskCount = tasks.size();
        for (int i = 0; i < taskCount; ++i) {
            Task task = tasks.get(i);
            map.put((Object)task.key, (Object)task);
        }
        return map;
    }

    public void dump(String prefix, PrintWriter writer) {
        String innerPrefix = prefix + "  ";
        writer.print(prefix);
        writer.print(TAG);
        writer.print(" numStackTasks=");
        writer.print(this.mStackTaskList.size());
        writer.println();
        ArrayList<Task> tasks = this.mStackTaskList.getTasks();
        int taskCount = tasks.size();
        for (int i = 0; i < taskCount; ++i) {
            tasks.get(i).dump(innerPrefix, writer);
        }
    }

    public static interface TaskStackCallbacks {
        public void onStackTaskAdded(TaskStack var1, Task var2);

        public void onStackTaskRemoved(TaskStack var1, Task var2, Task var3, AnimationProps var4, boolean var5, boolean var6);

        public void onStackTasksRemoved(TaskStack var1);

        public void onStackTasksUpdated(TaskStack var1);
    }
}

