/*
 * Decompiled with CFR 0.152.
 */
package com.android.systemui.shared.recents.model;

import android.app.ActivityManager;
import android.graphics.Bitmap;
import android.graphics.GraphicBuffer;
import android.graphics.Rect;

public class ThumbnailData {
    public final Bitmap thumbnail;
    public int orientation;
    public Rect insets;
    public boolean reducedResolution;
    public boolean isRealSnapshot;
    public int windowingMode;
    public float scale;

    public ThumbnailData() {
        this.thumbnail = null;
        this.orientation = 0;
        this.insets = new Rect();
        this.reducedResolution = false;
        this.scale = 1.0f;
        this.isRealSnapshot = true;
        this.windowingMode = 0;
    }

    public ThumbnailData(ActivityManager.TaskSnapshot snapshot) {
        this.thumbnail = Bitmap.createHardwareBitmap((GraphicBuffer)snapshot.getSnapshot());
        this.insets = new Rect(snapshot.getContentInsets());
        this.orientation = snapshot.getOrientation();
        this.reducedResolution = snapshot.isReducedResolution();
        this.scale = snapshot.getScale();
        this.isRealSnapshot = snapshot.isRealSnapshot();
        this.windowingMode = snapshot.getWindowingMode();
    }
}

