/*
 * Decompiled with CFR 0.152.
 */
package com.android.systemui.shared.system;

import android.app.ActivityManager;
import android.os.RemoteException;
import android.util.Log;
import android.view.IRecentsAnimationController;
import com.android.systemui.shared.recents.model.ThumbnailData;

public class RecentsAnimationControllerCompat {
    private static final String TAG = RecentsAnimationControllerCompat.class.getSimpleName();
    private IRecentsAnimationController mAnimationController;

    public RecentsAnimationControllerCompat() {
    }

    public RecentsAnimationControllerCompat(IRecentsAnimationController animationController) {
        this.mAnimationController = animationController;
    }

    public ThumbnailData screenshotTask(int taskId) {
        try {
            ActivityManager.TaskSnapshot snapshot = this.mAnimationController.screenshotTask(taskId);
            return snapshot != null ? new ThumbnailData(snapshot) : new ThumbnailData();
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)"Failed to screenshot task", (Throwable)e);
            return new ThumbnailData();
        }
    }

    public void setInputConsumerEnabled(boolean enabled) {
        try {
            this.mAnimationController.setInputConsumerEnabled(enabled);
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)"Failed to set input consumer enabled state", (Throwable)e);
        }
    }

    public void setAnimationTargetsBehindSystemBars(boolean behindSystemBars) {
        try {
            this.mAnimationController.setAnimationTargetsBehindSystemBars(behindSystemBars);
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)"Failed to set whether animation targets are behind system bars", (Throwable)e);
        }
    }

    public void finish(boolean toHome) {
        try {
            this.mAnimationController.finish(toHome);
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)"Failed to finish recents animation", (Throwable)e);
        }
    }
}

